/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CLCommandHelper {
    public static final Logger LOGGER = Logger.getLogger(CLCommandHelper.class);

    public static boolean isFlagSet(String[] args, String ... flags) {
        if (args == null) {
            return false;
        }
        if (flags == null) {
            return false;
        }
        for (String flag : flags) {
            if (flag == null || flag.trim().length() == 0) {
                return false;
            }
            Object flagToCheck = flag.trim();
            if (!((String)flagToCheck).startsWith("-")) {
                flagToCheck = "-" + (String)flagToCheck;
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals(flagToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPluginName(String[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].trim().startsWith("-")) continue;
            return args[i];
        }
        return null;
    }

    protected static Map<String, Collection<IPlugin>> checkDependencies(IPlugin toCheck, boolean allowMultipleServices) {
        Collection<String> provisions = toCheck.getProperties().getProvisions();
        HashMap<String, Collection<IPlugin>> dependers = new HashMap<String, Collection<IPlugin>>();
        if (provisions != null) {
            Iterator<String> prIt = provisions.iterator();
            while (prIt != null && prIt.hasNext()) {
                Collection<IPlugin> reqs;
                String prov = prIt.next();
                boolean getAnother = false;
                Collection<IPlugin> all = PluginManager.getInstance().getPluginsProviding(prov);
                if (all != null && allowMultipleServices) {
                    Iterator<IPlugin> plugins = all.iterator();
                    while (plugins != null && plugins.hasNext()) {
                        IPlugin iPlugin = plugins.next();
                        if (iPlugin.getName().equals(toCheck.getName())) continue;
                        getAnother = true;
                        break;
                    }
                }
                if (getAnother || (reqs = CLCommandHelper.getRequirers(prov)).isEmpty()) continue;
                dependers.put(prov, reqs);
            }
        }
        return dependers;
    }

    public static List<IPlugin> getDependers(IPlugin toCheck, boolean allowMultipleServices) {
        ArrayList<IPlugin> result = new ArrayList<IPlugin>();
        result.add(toCheck);
        Map<String, Collection<IPlugin>> dependers = CLCommandHelper.checkDependencies(toCheck, allowMultipleServices);
        Collection<Collection<IPlugin>> deps = dependers.values();
        result.addAll(CLCommandHelper.getDependers(deps, allowMultipleServices));
        return result;
    }

    private static List<IPlugin> getDependers(Collection<?> plugins, boolean allowMultipleServices) {
        ArrayList<IPlugin> result = new ArrayList<IPlugin>();
        for (Object o : plugins) {
            List<IPlugin> toAdd;
            if (o instanceof Collection) {
                toCheck = (Collection)o;
                toCheck.removeAll(result);
                toAdd = CLCommandHelper.getDependers(toCheck, allowMultipleServices);
            } else {
                toCheck = (IPlugin)o;
                toAdd = CLCommandHelper.getDependers((IPlugin)toCheck, allowMultipleServices);
            }
            result.removeAll(toAdd);
            result.addAll(toAdd);
        }
        return result;
    }

    private static Collection<IPlugin> getRequirers(String prov) {
        ArrayList<IPlugin> result = new ArrayList<IPlugin>();
        List<IPlugin> plugins = PluginManager.getInstance().getPlugins();
        for (IPlugin pl : plugins) {
            Collection<String> reqs = pl.getProperties().getRequirements();
            if (!reqs.contains(prov)) continue;
            result.add(pl);
        }
        return result;
    }
}

