/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.commands.CheckAllCommand;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CheckSelectedPlaceCommand
extends Command
implements CLCommand {
    private String _lolaPath;
    private static Logger _logger = Logger.getLogger(CheckSelectedPlaceCommand.class);

    public CheckSelectedPlaceCommand(String name, String path) {
        super(name);
        this._lolaPath = path;
    }

    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing)app.drawing();
        app.getUndoRedoManager().prepareUndoSnapshot(app.drawing());
        Vector selection = app.view().selection();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(this._lolaPath);
        LolaFileCreator creator = new LolaFileCreator();
        File netFile = creator.writeTemporaryLolaFile(drawing);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + netFile.getPath()));
        }
        for (Figure fig : selection) {
            String placeName;
            DirectLolaResult result;
            if (!(fig instanceof PlaceFigure) || fig instanceof VirtualPlaceFigure || (result = analyzer.checkPlaceBoundedness(placeName = creator.getNameForFigure(fig), netFile)) == null) continue;
            switch (result.getStatus()) {
                case YES: {
                    LolaGUIHelper.colorFigure(fig, Color.GREEN);
                    break;
                }
                case NO: {
                    LolaGUIHelper.colorFigure(fig, Color.RED);
                    break;
                }
            }
        }
        app.getUndoRedoManager().commitUndoSnapshot(app.drawing());
    }

    public void execute(String[] args, PrintStream response) {
    }

    public String getDescription() {
        return "Check if the selected place is bounded";
    }
}

