/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.io;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.gui.CPNDrawing;
import de.renew.ioontology.FileFilter;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.LolaFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class LolaExportFormat
extends AbstractDrawingExportFormat {
    public static final Logger LOGGER = Logger.getLogger(LolaExportFormat.class);

    public LolaExportFormat() {
        super("Lola", (FileFilter)new LolaFileFilter());
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        if (drawing instanceof CPNDrawing) {
            result = true;
        }
        return result;
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File path) throws Exception {
        LolaFileCreator creator = new LolaFileCreator();
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            creator.writeLolaFile(stream, (CPNDrawing)drawing);
            stream.flush();
            stream.close();
        }
        if (result != null) {
            LOGGER.info((Object)("[Lola Export] Successfully exported drawing to " + String.valueOf(path)));
        } else {
            LOGGER.error((Object)"Failure in LolaExportFormat: result == null");
        }
        return result;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in LolaExportFormat: result == null";
        return result;
    }
}

