/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.logging.gui.AppenderFactory;
import de.renew.logging.gui.ConfigureLoggingController;
import de.renew.logging.gui.TreeNodeAppenderWrapper;
import de.renew.logging.gui.TreeNodeLoggerWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ConfigureLoggingTab
extends JPanel {
    private ConfigureLoggingController _controller;
    private JTree _loggerTree;
    private JScrollPane _infoPane;
    private JSplitPane _splitPane;

    public ConfigureLoggingTab(ConfigureLoggingController controller) {
        super(new BorderLayout());
        this._controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.setName("Logging");
        this._loggerTree = new JTree();
        this._loggerTree.addMouseListener(new PopupMenuMouseListener());
        TreeSelectionModel selModel = this._loggerTree.getSelectionModel();
        selModel.setSelectionMode(1);
        this._loggerTree.addTreeSelectionListener(this._controller);
        JScrollPane leftComponent = new JScrollPane(this._loggerTree);
        leftComponent.setMinimumSize(new Dimension(300, 200));
        this._splitPane = new JSplitPane(1, leftComponent, this._infoPane);
        this.add((Component)this._splitPane, "Center");
        JPanel panel = new JPanel();
        panel.add((Component)new JLabel("Select an appender to display and edit attributes."), "North");
        panel.setPreferredSize(new Dimension(300, 200));
        this.setRightSide(panel);
    }

    protected void setRootNode(MutableTreeNode root) {
        this._loggerTree.setModel(new DefaultTreeModel(root));
    }

    protected void setRightSide(JComponent c) {
        this._splitPane.setRightComponent(c);
        this._splitPane.resetToPreferredSizes();
    }

    private class PopupMenuMouseListener
    extends MouseAdapter {
        private PopupMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTree && e.isPopupTrigger()) {
                this.openPopup((JTree)c, e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTree && e.isPopupTrigger()) {
                this.openPopup((JTree)c, e);
            }
        }

        private void openPopup(JTree tree, MouseEvent e) {
            Object wrapper;
            Point p = e.getPoint();
            TreePath path = tree.getPathForLocation(p.x, p.y);
            if (path == null) {
                return;
            }
            Object o = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item1 = new JMenuItem("add logger");
            item1.addActionListener(ConfigureLoggingTab.this._controller.createAddLoggerAction());
            item1.setEnabled(false);
            popup.add(item1);
            JMenuItem item2 = new JMenuItem("remove logger");
            item2.setEnabled(false);
            popup.add(item2);
            popup.addSeparator();
            JMenu menu3 = new JMenu("add appender");
            menu3.setEnabled(false);
            popup.add(menu3);
            JMenuItem item4 = new JMenuItem("remove appender");
            item4.setEnabled(false);
            popup.add(item4);
            JMenuItem item5 = new JMenuItem("export configuration");
            item5.addActionListener(ConfigureLoggingTab.this._controller.createExportConfigurationAction());
            popup.add(item5);
            if (o instanceof TreeNodeLoggerWrapper) {
                wrapper = (TreeNodeLoggerWrapper)o;
                item2.setEnabled(true);
                item2.addActionListener(ConfigureLoggingTab.this._controller.createRemoveLoggerAction(((TreeNodeLoggerWrapper)wrapper).getLogger().getName()));
                String[] appenderTypes = AppenderFactory.getInstance().getAllAppenderTypes();
                for (int x = 0; x < appenderTypes.length; ++x) {
                    JMenuItem item = new JMenuItem(appenderTypes[x]);
                    item.addActionListener(ConfigureLoggingTab.this._controller.createAddAppenderAction(((TreeNodeLoggerWrapper)wrapper).getLogger().getName(), appenderTypes[x]));
                    menu3.add(item);
                }
                menu3.setEnabled(true);
            }
            if (o instanceof TreeNodeAppenderWrapper) {
                wrapper = (TreeNodeAppenderWrapper)o;
                menu3.setEnabled(true);
                item4.addActionListener(ConfigureLoggingTab.this._controller.createRemoveAppenderAction(((TreeNodeAppenderWrapper)wrapper).getLogger().getName(), ((TreeNodeAppenderWrapper)wrapper).getAppender()));
                item4.setEnabled(true);
            } else if (o instanceof String) {
                item1.setEnabled(true);
            }
            popup.show(tree, e.getX(), e.getY());
        }
    }
}

