/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.common.SimulatorEvent;
import de.renew.logging.gui.AbstractRepository;
import de.renew.logging.gui.LoggerRepository;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceChangeListener;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class MainRepository
extends AbstractRepository
implements StepTraceChangeListener {
    private Map<String, LoggerRepository> _loggerRepositories = new Hashtable<String, LoggerRepository>();
    private Map<StepIdentifier, StepTrace> _stepTraces = new Hashtable<StepIdentifier, StepTrace>();

    public LoggerRepository getLoggerRepository(String loggerName, int capacity) {
        LoggerRepository lRepository = this._loggerRepositories.get(loggerName);
        if (lRepository == null) {
            lRepository = new LoggerRepository(this, capacity);
            this._loggerRepositories.put(loggerName, lRepository);
            this.addRepositoryChangeListener(lRepository);
        }
        lRepository.setCapacity(capacity);
        return lRepository;
    }

    @Override
    public void addEvent(SimulatorEvent event) {
        StepTrace stepTrace = this._stepTraces.get(event.getStep());
        if (stepTrace == null) {
            stepTrace = new StepTrace(event.getStep());
            stepTrace.addStepTraceChangeListener(this);
            this._stepTraces.put(event.getStep(), stepTrace);
            this.fireStepTraceAdded(stepTrace);
        }
        stepTrace.log(event.getMessage());
    }

    @Override
    public StepTrace[] getStepTraces(StepIdentifier[] steps) {
        Vector<StepTrace> traces = new Vector<StepTrace>();
        for (int x = 0; x < steps.length; ++x) {
            StepTrace trace;
            if (steps[x] == null || (trace = this._stepTraces.get(steps[x])) == null) continue;
            traces.add(trace);
        }
        return traces.toArray(new StepTrace[0]);
    }

    @Override
    public StepTrace[] getAllStepTraces() {
        return this._stepTraces.entrySet().toArray(new StepTrace[0]);
    }

    @Override
    public StepTrace getStepTrace(StepIdentifier stepIdentifier) {
        StepTrace trace = this._stepTraces.get(stepIdentifier);
        return trace;
    }

    @Override
    public boolean removeStepTrace(StepIdentifier stepIdentifier) {
        StepTrace stepTrace = this.getStepTrace(stepIdentifier);
        if (stepTrace != null && !this.fireStepTraceRemoveRequest(stepTrace)) {
            this._stepTraces.remove(stepIdentifier);
            return true;
        }
        return false;
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        this.fireStepTraceChanged(stepTrace);
    }
}

