/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui.actions;

import CH.ifa.draw.DrawPlugin;
import de.renew.draw.ui.api.ApplicationApi;
import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class AddFilesAction
extends NavigatorAction {
    private final FilesystemController _fileSystemCtrl;

    public AddFilesAction(FilesystemController filesystemControl) {
        super("Add Files (Ctrl+Shift+O)", "/de/renew/navigator/images/add.png", KeyStroke.getKeyStroke("control shift O"));
        this._fileSystemCtrl = filesystemControl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DrawPlugin currentPlugin = DrawPlugin.getCurrent();
        if (currentPlugin != null) {
            JFileChooser fc = new JFileChooser(ApplicationApi.getLastPath());
            FileFilter fileFilter = this._fileSystemCtrl.getFileFilter();
            fc.setFileSelectionMode(2);
            fc.setAcceptAllFileFilterUsed(false);
            fc.addChoosableFileFilter(fileFilter);
            fc.setFileFilter(fileFilter);
            fc.setFileHidingEnabled(true);
            fc.setMultiSelectionEnabled(true);
            int returnVal = fc.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            File[] files = fc.getSelectedFiles();
            this._fileSystemCtrl.loadRootDirectories(Arrays.asList(files));
            File parent = files[0].getParentFile();
            if (parent != null && parent.isDirectory()) {
                currentPlugin.getIOHelper().setLastPath(parent);
            }
        }
    }
}

