/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class NavigatorFileTree
extends Model {
    private List<SearchFilter> _activeFileFilters = new ArrayList<SearchFilter>();
    private SearchFilter _textSearch;
    private final List<BackgroundTask> _backgroundTasks = new LinkedList<BackgroundTask>();

    public List<SearchFilter> getActiveFileFilters() {
        return this._activeFileFilters;
    }

    public void setActiveFileFilters(List<SearchFilter> activeFileFilters) {
        this._activeFileFilters = activeFileFilters;
        this.setChanged();
    }

    public List<TreeElement> getTreeRoots() {
        return this._elements;
    }

    public void activateFileFilter(SearchFilter fileFilter) {
        this._activeFileFilters.add(fileFilter);
        this.setChanged();
    }

    public void deactivateFileFilter(SearchFilter fileFilter) {
        if (!this._activeFileFilters.remove(fileFilter)) {
            throw new IllegalArgumentException(String.format("The file filter was not activated yet: %s", fileFilter));
        }
        this.setChanged();
    }

    public void deactivateFileFilter(String name) {
        SearchFilter filter = this.getFileFilterByName(name);
        if (filter == null) {
            return;
        }
        this.deactivateFileFilter(filter);
    }

    public SearchFilter getFileFilterByName(String name) {
        for (SearchFilter filter : this._activeFileFilters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    public void clearTreeRoots() {
        this._elements.clear();
        this.setChanged();
    }

    public void expandAll() {
        for (TreeElement element : this._elements) {
            element.expandAll();
        }
    }

    public void clear() {
        this._activeFileFilters.clear();
        this._elements.clear();
    }

    public List<BackgroundTask> getBackgroundTasks() {
        return this._backgroundTasks;
    }

    public void addBackgroundTask(BackgroundTask task) {
        this._backgroundTasks.add(task);
        this.setChanged();
    }

    public void removeBackgroundTask(BackgroundTask task) {
        this._backgroundTasks.remove(task);
        this.setChanged();
    }

    public SearchFilter getTextSearch() {
        return this._textSearch;
    }

    public void setTextSearch(SearchFilter textSearch) {
        this._textSearch = textSearch;
        this.setChanged();
    }
}

