/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.gui;

import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import de.renew.application.SimulatorPlugin;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.formalism.gui.FormalismGuiCreator;
import de.renew.gui.GuiPlugin;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.PaletteHolder;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class JavaGuiCreator
implements FormalismGuiCreator {
    public static final Logger LOGGER = Logger.getLogger(JavaGuiCreator.class);
    private boolean _toolsVisible = false;
    private Palette _sequentialTools = null;
    private JCheckBoxMenuItem _sequentialItem;

    @Override
    public JMenuItem createMenu() {
        int mult = PropertyHelper.getIntProperty((Properties)this.getSimulatorPlugin().getProperties(), (String)"de.renew.simulatorMode", (int)1);
        boolean isSequential = mult == -1;
        this._sequentialItem = new JCheckBoxMenuItem("Show sequential-only arcs", isSequential);
        this._sequentialItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaGuiCreator.this.sequentialChanged();
            }
        });
        this.sequentialChanged();
        return this._sequentialItem;
    }

    @Override
    public Palette createPalette() {
        return null;
    }

    @Override
    public void formalismActivated() {
    }

    @Override
    public void formalismDeactivated() {
        this.hideSequentialPalette();
    }

    private void sequentialChanged() {
        boolean isSequential = this._sequentialItem.isSelected();
        if (isSequential) {
            this.createSequentialPalette();
        } else {
            this.hideSequentialPalette();
        }
    }

    private void hideSequentialPalette() {
        if (this._sequentialTools != null && this._toolsVisible) {
            GuiPlugin guiPlugin = GuiPlugin.getCurrent();
            guiPlugin.getPaletteHolder().removePalette(this._sequentialTools);
            this._toolsVisible = false;
        }
    }

    private void createSequentialPalette() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        PaletteHolder paletteHolder = guiPlugin.getPaletteHolder();
        if (this._sequentialTools == null) {
            guiPlugin.openGui();
            DrawingEditor editor = guiPlugin.getDrawingEditor();
            ConnectionTool tool = new ConnectionTool(editor, (ConnectionFigure)InhibitorConnection.InhibitorArc);
            this._sequentialTools = new Palette("net elements for sequential mode");
            ToolButton button = paletteHolder.createToolButton("/de/renew/gui/images/INHIB", "InhibitorArc Tool", (Tool)tool);
            this._sequentialTools.add(button);
            tool = new ConnectionTool(editor, (ConnectionFigure)HollowDoubleArcConnection.HollowArc);
            button = paletteHolder.createToolButton("/de/renew/gui/images/DHARC", "ClearArc Tool", (Tool)tool);
            this._sequentialTools.add(button);
        }
        if (!this._toolsVisible) {
            PluginProperties props = this.getSimulatorPlugin().getProperties();
            if (!props.getProperty("de.renew.simulatorMode", "").trim().equals("-1")) {
                props.setProperty("de.renew.simulatorMode", "-1");
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"For your convenience, the sequential simulation mode has been turned on, too.");
                    LOGGER.info((Object)"In order to reset your simulation to concurrent simulation mode do: set de.renew.simulatorMode=1");
                    LOGGER.info((Object)"or uncheck the propterty in the \"Configure Simulation\" dialog.");
                }
            }
            paletteHolder.addPalette(this._sequentialTools);
            this._toolsVisible = true;
        }
    }

    private SimulatorPlugin getSimulatorPlugin() {
        return (SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
    }

    public FormalismGuiCreator getSequentialJavaGuiCreator() {
        return new SequentialJavaGuiCreator();
    }

    private class SequentialJavaGuiCreator
    implements FormalismGuiCreator {
        private SequentialJavaGuiCreator() {
        }

        @Override
        public JMenuItem createMenu() {
            return null;
        }

        @Override
        public Palette createPalette() {
            return null;
        }

        @Override
        public void formalismActivated() {
            JavaGuiCreator.this.createSequentialPalette();
        }

        @Override
        public void formalismDeactivated() {
            JavaGuiCreator.this.hideSequentialPalette();
        }
    }
}

