/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.io.ImageFileFilter;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public abstract class AbstractFileDragDropListener
implements DropTargetListener {
    private static final Logger logger = Logger.getLogger(AbstractFileDragDropListener.class);

    protected FileFilter getFileFilter() {
        return Objects.requireNonNull(DrawPlugin.getCurrent()).getIOHelper().getKnownFileFiltersWithImportFormats();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        DataFlavor[] flavors;
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
            try {
                File[] filesArrayImages;
                if (!flavor.isFlavorJavaFileListType()) continue;
                List files = (List)transferable.getTransferData(flavor);
                ArrayList<File> filteredFilesDrawings = new ArrayList<File>();
                FileFilter fileFilterDrawings = this.getFileFilter();
                ArrayList<File> filteredFilesImages = new ArrayList<File>();
                ImageFileFilter fileFilterImages = new ImageFileFilter();
                for (File file : files) {
                    if (fileFilterDrawings.accept(file)) {
                        filteredFilesDrawings.add(file);
                        continue;
                    }
                    if (!fileFilterImages.accept(file)) continue;
                    filteredFilesImages.add(file);
                }
                File[] filesArrayDrawings = filteredFilesDrawings.toArray(new File[0]);
                if (filesArrayDrawings.length > 0) {
                    this.handleFilesDrawing(filesArrayDrawings, event.getLocation());
                }
                if ((filesArrayImages = filteredFilesImages.toArray(new File[0])).length <= 0) continue;
                this.handleFilesImage(filesArrayImages, event.getLocation());
            }
            catch (UnsupportedFlavorException | IOException e) {
                logger.error((Object)e.getMessage());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(AbstractFileDragDropListener.class.getSimpleName() + ": " + String.valueOf(e)));
            }
        }
        event.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    protected abstract void handleFilesDrawing(File[] var1, Point var2);

    protected abstract void handleFilesImage(File[] var1, Point var2);
}

