/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.contrib.PolygonHandle;
import CH.ifa.draw.contrib.PolygonScaleHandle;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.InsertPointHandle;
import CH.ifa.draw.figures.PolyLineable;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PolygonFigure
extends AttributeFigure
implements OutlineFigure,
PolyLineable {
    public static Logger _logger = Logger.getLogger(PolygonFigure.class);
    static final int TOO_CLOSE = 2;
    private static final long serialVersionUID = 6254089689239215026L;
    private static final String SMOOTHINGSTRATEGY = "ch.ifa.draw.polygon.smoothing";
    private static final String SMOOTHING_INLINE = "alignment";
    private static final String SMOOTHING_DISTANCES = "distances";
    private final int polygonFigureSerializedDataVersion = 1;
    public static final int LINE_SHAPE = 0;
    public static final int BSPLINE_SHAPE = 1;
    protected Polygon _poly = new Polygon();

    public PolygonFigure() {
    }

    public PolygonFigure(int x, int y) {
        this._poly.addPoint(x, y);
    }

    public PolygonFigure(Polygon p) {
        this._poly = new Polygon(p.xpoints, p.ypoints, p.npoints);
    }

    @Override
    public Rectangle displayBox() {
        return PolygonFigure.bounds(this._poly);
    }

    @Override
    public boolean isEmpty() {
        return this._poly.npoints < 3 || this.size().width < 2 && this.size().height < 2;
    }

    @Override
    public Vector<FigureHandle> handles() {
        int i;
        Vector<FigureHandle> handles = new Vector<FigureHandle>(this._poly.npoints);
        for (i = 0; i < this._poly.npoints; ++i) {
            handles.addElement(new PolygonHandle(this, PolygonFigure.locator(i), i));
        }
        for (i = 0; i < this._poly.npoints - 1; ++i) {
            handles.addElement(new InsertPointHandle(this, i));
        }
        handles.addElement(new PolygonScaleHandle(this));
        return handles;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        Rectangle r = this.displayBox();
        int dx = origin.x - r.x;
        int dy = origin.y - r.y;
        this._poly.translate(dx, dy);
        r = this.displayBox();
        Point oldCorner = new Point(r.x + r.width, r.y + r.height);
        Polygon p = this.getPolygon();
        this.scaleRotate(oldCorner, p, corner, true, true);
    }

    public Polygon getPolygon() {
        return new Polygon(this._poly.xpoints, this._poly.ypoints, this._poly.npoints);
    }

    @Override
    public Polygon outline() {
        return this.getPolygon();
    }

    @Override
    public Point center() {
        return PolygonFigure.center(this._poly);
    }

    public Enumeration<Point> points() {
        Vector<Point> pts = new Vector<Point>(this._poly.npoints);
        for (int i = 0; i < this._poly.npoints; ++i) {
            pts.addElement(new Point(this._poly.xpoints[i], this._poly.ypoints[i]));
        }
        return pts.elements();
    }

    @Override
    public int pointCount() {
        return this._poly.npoints;
    }

    @Override
    public void basicMoveBy(int dx, int dy) {
        this._poly.translate(dx, dy);
    }

    @Override
    public void drawBackground(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            throw new IllegalStateException("Graphics type not a Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.fill(this.createPath());
    }

    @Override
    public void drawFrame(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            throw new IllegalStateException("Graphics type not a Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.draw(this.createPath());
    }

    private GeneralPath createPath() {
        int i;
        GeneralPath shape = new GeneralPath();
        int[] x = this._poly.xpoints;
        int[] y = this._poly.ypoints;
        int max = this._poly.npoints;
        shape.moveTo(x[i], y[i]);
        for (i = 0; i < max; ++i) {
            shape.lineTo(x[i], y[i]);
        }
        shape.closePath();
        return shape;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        _logger.debug((Object)("Contains Point x=" + x + ", y= " + y + " ? "));
        return this._poly.contains(x, y);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopPolygonConnector(this);
    }

    public void addPoint(int x, int y) {
        this._poly.addPoint(x, y);
        this.changed();
    }

    @Override
    public void setPointAt(Point p, int i) {
        this.willChange();
        this._poly.xpoints[i] = p.x;
        this._poly.ypoints[i] = p.y;
        this._poly = new Polygon(this._poly.xpoints, this._poly.ypoints, this._poly.npoints);
        this.changed();
    }

    @Override
    public void insertPointAt(Point p, int i) {
        int j;
        this.willChange();
        int n = this._poly.npoints + 1;
        int[] xs = new int[n];
        int[] ys = new int[n];
        for (j = 0; j < i; ++j) {
            xs[j] = this._poly.xpoints[j];
            ys[j] = this._poly.ypoints[j];
        }
        xs[i] = p.x;
        ys[i] = p.y;
        for (j = i; j < this._poly.npoints; ++j) {
            xs[j + 1] = this._poly.xpoints[j];
            ys[j + 1] = this._poly.ypoints[j];
        }
        this._poly = new Polygon(xs, ys, n);
        this.changed();
    }

    @Override
    public void removePointAt(int i) {
        int j;
        this.willChange();
        int n = this._poly.npoints - 1;
        int[] xs = new int[n];
        int[] ys = new int[n];
        for (j = 0; j < i; ++j) {
            xs[j] = this._poly.xpoints[j];
            ys[j] = this._poly.ypoints[j];
        }
        for (j = i; j < n; ++j) {
            xs[j] = this._poly.xpoints[j + 1];
            ys[j] = this._poly.ypoints[j + 1];
        }
        this._poly = new Polygon(xs, ys, n);
        this.changed();
    }

    public void scaleRotate(Point anchor, Polygon originalPolygon, Point p, boolean scale, boolean rotate) {
        this.willChange();
        Point ctr = PolygonFigure.center(originalPolygon);
        double anchorLen = Geom.length(ctr.x, ctr.y, anchor.x, anchor.y);
        if (anchorLen > 0.0) {
            double newLen = Geom.length(ctr.x, ctr.y, p.x, p.y);
            double ratio = newLen / anchorLen;
            double anchorAngle = Math.atan2(anchor.y - ctr.y, anchor.x - ctr.x);
            double newAngle = Math.atan2(p.y - ctr.y, p.x - ctr.x);
            double rotation = newAngle - anchorAngle;
            if (!scale) {
                ratio = 1.0;
            }
            if (!rotate) {
                rotation = 0.0;
            }
            int n = originalPolygon.npoints;
            int[] xs = new int[n];
            int[] ys = new int[n];
            for (int i = 0; i < n; ++i) {
                int x = originalPolygon.xpoints[i];
                int y = originalPolygon.ypoints[i];
                double l = (double)Geom.length(ctr.x, ctr.y, x, y) * ratio;
                double a = Math.atan2(y - ctr.y, x - ctr.x) + rotation;
                xs[i] = (int)((double)ctr.x + l * Math.cos(a) + 0.5);
                ys[i] = (int)((double)ctr.y + l * Math.sin(a) + 0.5);
            }
            this._poly = new Polygon(xs, ys, n);
        }
        this.changed();
    }

    public void smoothPoints() {
        boolean removed;
        this.willChange();
        int n = this._poly.npoints;
        do {
            removed = false;
            int i = 0;
            while (i < n && n >= 3) {
                int nxt = (i + 1) % n;
                int prv = (i - 1 + n) % n;
                String strategy = Objects.requireNonNull(DrawPlugin.getCurrent()).getProperties().getProperty(SMOOTHINGSTRATEGY);
                boolean doremove = false;
                if (strategy == null || strategy.isEmpty() || SMOOTHING_INLINE.equals(strategy)) {
                    if (PolygonFigure.distanceFromLine(this._poly.xpoints[prv], this._poly.ypoints[prv], this._poly.xpoints[nxt], this._poly.ypoints[nxt], this._poly.xpoints[i], this._poly.ypoints[i]) < 2.0) {
                        doremove = true;
                    }
                } else if (SMOOTHING_DISTANCES.equals(strategy) && Math.abs(this._poly.xpoints[prv] - this._poly.xpoints[i]) < 5 && Math.abs(this._poly.ypoints[prv] - this._poly.ypoints[i]) < 5) {
                    doremove = true;
                }
                if (doremove) {
                    removed = true;
                    --n;
                    for (int j = i; j < n; ++j) {
                        this._poly.xpoints[j] = this._poly.xpoints[j + 1];
                        this._poly.ypoints[j] = this._poly.ypoints[j + 1];
                    }
                    continue;
                }
                ++i;
            }
        } while (removed);
        if (n != this._poly.npoints) {
            this._poly = new Polygon(this._poly.xpoints, this._poly.ypoints, n);
        }
        this.changed();
    }

    public int splitSegment(int x, int y) {
        int i = this.findSegment(x, y);
        if (i != -1) {
            this.insertPointAt(new Point(x, y), i + 1);
            return i + 1;
        }
        return -1;
    }

    @Override
    public Point pointAt(int i) {
        return new Point(this._poly.xpoints[i], this._poly.ypoints[i]);
    }

    public Point outermostPoint() {
        Point ctr = this.center();
        int outer = 0;
        long dist = 0L;
        for (int i = 0; i < this._poly.npoints; ++i) {
            long d = Geom.length2(ctr.x, ctr.y, this._poly.xpoints[i], this._poly.ypoints[i]);
            if (d <= dist) continue;
            dist = d;
            outer = i;
        }
        return new Point(this._poly.xpoints[outer], this._poly.ypoints[outer]);
    }

    public int findSegment(int x, int y) {
        double dist = 2.0;
        int best = -1;
        for (int i = 0; i < this._poly.npoints; ++i) {
            int n = (i + 1) % this._poly.npoints;
            double d = PolygonFigure.distanceFromLine(this._poly.xpoints[i], this._poly.ypoints[i], this._poly.xpoints[n], this._poly.ypoints[n], x, y);
            if (!(d < dist)) continue;
            dist = d;
            best = i;
        }
        return best;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this._poly.npoints);
        for (int i = 0; i < this._poly.npoints; ++i) {
            dw.writeInt(this._poly.xpoints[i]);
            dw.writeInt(this._poly.ypoints[i]);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        int[] xs = new int[size];
        int[] ys = new int[size];
        for (int i = 0; i < size; ++i) {
            xs[i] = dr.readInt();
            ys[i] = dr.readInt();
        }
        this._poly = new Polygon(xs, ys, size);
    }

    public static Locator locator(final int pointIndex) {
        return new AbstractLocator(){

            @Override
            public Point locate(Figure owner) {
                PolygonFigure plf = (PolygonFigure)owner;
                if (pointIndex < plf.pointCount()) {
                    return ((PolygonFigure)owner).pointAt(pointIndex);
                }
                return new Point(-1, -1);
            }
        };
    }

    public static double distanceFromLine(int xa, int ya, int xb, int yb, int xc, int yc) {
        int xdiff = xb - xa;
        int ydiff = yb - ya;
        long l2 = (long)xdiff * (long)xdiff + (long)ydiff * (long)ydiff;
        if (l2 == 0L) {
            return Geom.length(xa, ya, xc, yc);
        }
        double rnum = (ya - yc) * (ya - yb) - (xa - xc) * (xb - xa);
        double r = rnum / (double)l2;
        if (r < 0.0 || r > 1.0) {
            return Double.MAX_VALUE;
        }
        double xi = (double)xa + r * (double)xdiff;
        double yi = (double)ya + r * (double)ydiff;
        double xd = (double)xc - xi;
        double yd = (double)yc - yi;
        return Math.sqrt(xd * xd + yd * yd);
    }

    public static Rectangle bounds(Polygon p) {
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int n = p.npoints;
        for (int i = 0; i < n; ++i) {
            int x = p.xpoints[i];
            int y = p.ypoints[i];
            if (x > maxx) {
                maxx = x;
            }
            if (x < minx) {
                minx = x;
            }
            if (y > maxy) {
                maxy = y;
            }
            if (y >= miny) continue;
            miny = y;
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public static Point center(Polygon p) {
        long sx = 0L;
        long sy = 0L;
        int n = p.npoints;
        for (int i = 0; i < n; ++i) {
            sx += (long)p.xpoints[i];
            sy += (long)p.ypoints[i];
        }
        return new Point((int)(sx / (long)n), (int)(sy / (long)n));
    }

    public static Point chop(Polygon poly, Point p) {
        int i;
        Point ctr = PolygonFigure.center(poly);
        int cx = -1;
        int cy = -1;
        long len = Long.MAX_VALUE;
        for (i = 0; i < poly.npoints; ++i) {
            long cl;
            int nxt = (i + 1) % poly.npoints;
            Point chop = Geom.intersect(poly.xpoints[i], poly.ypoints[i], poly.xpoints[nxt], poly.ypoints[nxt], p.x, p.y, ctr.x, ctr.y);
            if (chop == null || (cl = Geom.length2(chop.x, chop.y, p.x, p.y)) >= len) continue;
            len = cl;
            cx = chop.x;
            cy = chop.y;
        }
        if (len == Long.MAX_VALUE) {
            for (i = 0; i < poly.npoints; ++i) {
                long l = Geom.length2(poly.xpoints[i], poly.ypoints[i], p.x, p.y);
                if (l >= len) continue;
                len = l;
                cx = poly.xpoints[i];
                cy = poly.ypoints[i];
            }
        }
        return new Point(cx, cy);
    }
}

