/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureDrawingContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import org.freehep.graphicsio.HyperrefGraphics;

public abstract class AttributeFigure
extends AbstractFigure
implements FigureWithID {
    private static final String ID_ATTR = "FigureWithID";
    private static final long serialVersionUID = -10857585979273442L;
    private static FigureAttributes _defaultAttributes = null;
    public static final String LINE_STYLE_NORMAL = "";
    public static final String LINE_STYLE_DOTTED = "1 2";
    public static final String LINE_STYLE_DASHED = "10";
    public static final String LINE_STYLE_MEDIUM_DASHED = "15 10";
    public static final String LINE_STYLE_LONG_DASHED = "20";
    public static final String LINE_STYLE_DASH_DOTTED = "7 3 1 3";
    public static final String LINE_WIDTH_KEY = "LineWidth";
    public static final Integer LINE_WIDTH_DEFAULT = 1;
    private FigureAttributes _attributes;
    private final int _attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    public static Object getDefaultAttribute(String name) {
        if (_defaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return _defaultAttributes.get(name);
    }

    public void internalDraw(Graphics g) {
        Color frame;
        Color fill = this.getFillColor();
        if (!ColorMap.isTransparent(fill)) {
            g.setColor(fill);
            this.drawBackground(g);
        }
        if (!ColorMap.isTransparent(frame = this.getFrameColor())) {
            g.setColor(frame);
            Graphics2D g2 = (Graphics2D)g;
            String lineStyle = this.getLineStyle();
            BasicStroke stroke = (BasicStroke)g2.getStroke();
            BasicStroke bs = new BasicStroke(this.getLineWidth().intValue(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), this.lineStyle2ArrayOfFloat(lineStyle), stroke.getDashPhase());
            g2.setStroke(bs);
            this.drawFrame(g2);
            g2.setStroke(stroke);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.isVisible()) {
            if (g instanceof HyperrefGraphics && this.hasAttribute("targetLocation").booleanValue()) {
                ((HyperrefGraphics)g).drawLink((Shape)this.displayBox(), (String)this.getAttribute("targetLocation"));
            }
            this.internalDraw(g);
            if (g instanceof HyperrefGraphics && this.hasAttribute("targetLocation").booleanValue()) {
                ((HyperrefGraphics)g).drawLinkEnd();
            }
        }
    }

    @Override
    public void draw(Graphics g, FigureDrawingContext dc) {
        if (!dc.isVisible(this)) {
            return;
        }
        if (dc.isHighlighted(this)) {
            Color fill = this.getFillColor();
            Color frame = this.getFrameColor();
            Color text = null;
            if (ColorMap.isTransparent(fill) || ColorMap.isBackground(fill) || this instanceof PolyLineFigure) {
                if (this instanceof TextFigure) {
                    text = (Color)this.getAttribute("TextColor");
                    this.setTextColor(ColorMap.hilight(text));
                } else if (!ColorMap.isTransparent(frame) && !ColorMap.isBackground(fill)) {
                    this.setFrameColor(ColorMap.hilight(frame));
                }
            } else {
                this.setFillColor(ColorMap.hilight(fill));
            }
            this.internalDraw(g);
            this.setFillColor(fill);
            this.setFrameColor(frame);
            if (text != null) {
                this.setTextColor(text);
            }
        } else {
            this.internalDraw(g);
        }
    }

    protected void drawBackground(Graphics g) {
    }

    protected void drawFrame(Graphics g) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public void setFillColor(Color color) {
        if (this._attributes == null) {
            this._attributes = new FigureAttributes();
        }
        this._attributes.set("FillColor", color);
    }

    public void setFrameColor(Color color) {
        if (this._attributes == null) {
            this._attributes = new FigureAttributes();
        }
        this._attributes.set("FrameColor", color);
    }

    public void setTextColor(Color color) {
        if (this._attributes == null) {
            this._attributes = new FigureAttributes();
        }
        this._attributes.set("TextColor", color);
    }

    private static void initializeAttributes() {
        _defaultAttributes = new FigureAttributes();
        _defaultAttributes.set("FrameColor", Color.black);
        _defaultAttributes.set("FillColor", new Color(7396243));
        _defaultAttributes.set("TextColor", Color.black);
        _defaultAttributes.set("TextAlignment", 0);
        _defaultAttributes.set("ArrowMode", 0);
        _defaultAttributes.set("FontName", "Helvetica");
        _defaultAttributes.set("FontSize", 12);
        _defaultAttributes.set("FontStyle", 0);
        _defaultAttributes.set("LineShape", 0);
        _defaultAttributes.set("BSplineSegments", 15);
        _defaultAttributes.set("BSplineDegree", 2);
        _defaultAttributes.set(ID_ATTR, 0);
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    @Override
    public Object getAttribute(String name) {
        if (this._attributes != null && this._attributes.hasDefined(name)) {
            return this._attributes.get(name);
        }
        Object supAttr = super.getAttribute(name);
        if (supAttr == null) {
            return AttributeFigure.getDefaultAttribute(name);
        }
        return supAttr;
    }

    public Boolean hasAttribute(String name) {
        if (this._attributes != null && this._attributes.hasDefined(name)) {
            return true;
        }
        return super.getAttribute(name) != null;
    }

    public Enumeration<String> getAttributeKeys() {
        Enumeration<String> attr = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                return null;
            }
        };
        if (this._attributes != null) {
            attr = this._attributes.definedAttributes();
        }
        return attr;
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (this._attributes == null) {
            this._attributes = new FigureAttributes();
        }
        this._attributes.set(name, value);
        this.changed();
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        if (this._attributes == null) {
            dw.writeString("no_attributes");
        } else {
            dw.writeString("attributes");
            this._attributes.write(dw);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        Object lineStyle;
        super.read(dr);
        String s = dr.readString();
        if ("attributes".equalsIgnoreCase(s)) {
            if (this._attributes == null) {
                this._attributes = new FigureAttributes();
            }
            this._attributes.read(dr);
            Enumeration<String> attrenumeration = this._attributes.definedAttributes();
            while (attrenumeration.hasMoreElements()) {
                String attr = attrenumeration.nextElement();
                Object val = this._attributes.get(attr);
                super.setAttribute(attr, val);
            }
        }
        if ((lineStyle = this.getAttribute("LineStyle")) instanceof Integer) {
            Integer value = (Integer)lineStyle;
            if (value <= 0) {
                this.setAttribute("LineStyle", null);
            } else {
                this.setAttribute("LineStyle", lineStyle.toString());
            }
        }
    }

    @Override
    public int getID() {
        return (Integer)this.getAttribute(ID_ATTR);
    }

    @Override
    public void setID(int id) {
        this.setAttribute(ID_ATTR, id);
    }

    protected String getLineStyle() {
        String lineStyle = (String)this.getAttribute("LineStyle");
        return Objects.requireNonNullElse(lineStyle, LINE_STYLE_NORMAL);
    }

    protected Integer getLineWidth() {
        Integer lineWidth = (Integer)this.getAttribute(LINE_WIDTH_KEY);
        if (lineWidth == null) {
            return LINE_WIDTH_DEFAULT;
        }
        return lineWidth;
    }

    protected void setLineWidth(Integer width) {
        this.setAttribute(LINE_WIDTH_KEY, width);
    }

    protected void setLineStyle(String lineStyle) {
        this.setAttribute("LineStyle", lineStyle);
    }

    protected BasicStroke getBasicStroke(String lineStyle) {
        float[] f = this.lineStyle2ArrayOfFloat(lineStyle);
        return new BasicStroke(1.0f, 0, 2, 0.0f, f, 0.0f);
    }

    private float[] lineStyle2ArrayOfFloat(String lineStyle) {
        float[] f;
        if (!LINE_STYLE_NORMAL.equals(lineStyle) && !lineStyle.isEmpty()) {
            String[] split = lineStyle.split(" ");
            f = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                f[i] = Float.parseFloat(split[i]);
            }
        } else {
            f = null;
        }
        return f;
    }
}

