/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.ontology.FigureHandle;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private final int _elbowConnectionSerializedDataVersion = 1;

    @Override
    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    @Override
    public void layoutConnection() {
    }

    @Override
    public Vector<FigureHandle> handles() {
        int i;
        Vector<FigureHandle> handles = new Vector<FigureHandle>(this.fPoints.size() * 2);
        handles.addElement(new ChangeConnectionStartHandle(this));
        for (i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new NullHandle(this, ElbowConnection.locator(i)));
        }
        handles.addElement(new ChangeConnectionEndHandle(this));
        for (i = 0; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new ElbowHandle(this, i));
        }
        return handles;
    }

    @Override
    public Locator connectedTextLocator(Figure f) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point start = this.startPoint();
        Point end = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(start);
        if (start.x == end.x || start.y == end.y) {
            this.fPoints.addElement(end);
        } else {
            Rectangle r1 = this.start().owner().displayBox();
            Rectangle r2 = this.end().owner().displayBox();
            int dir = Geom.direction(r1.x + r1.width / 2, r1.y + r1.height / 2, r2.x + r2.width / 2, r2.y + r2.height / 2);
            if (dir == 1 || dir == 2) {
                this.fPoints.addElement(new Point(start.x, (start.y + end.y) / 2));
                this.fPoints.addElement(new Point(end.x, (start.y + end.y) / 2));
            } else {
                this.fPoints.addElement(new Point((start.x + end.x) / 2, start.y));
                this.fPoints.addElement(new Point((start.x + end.x) / 2, end.y));
            }
            this.fPoints.addElement(end);
        }
        this.changed();
    }
}

