/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Objects;
import org.apache.log4j.Logger;

@Deprecated(since="5.0", forRemoval=true)
public class TargetTool
extends CreationTool {
    public static final Logger LOGGER = Logger.getLogger(TargetTool.class);
    private static final String TARGET_LOCATION = "targetLocation";
    protected FloatingTextField _textField;
    private Figure _typingTarget;

    public TargetTool(DrawingEditor editor) {
        super(editor, new TextFigure(false));
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        if (this._typingTarget != null) {
            this.endEdit();
            this.editor().toolDone();
        } else {
            this._typingTarget = this.drawing().findFigureInside(x, y);
            if (this._typingTarget != null) {
                String targetLocation = (String)this._typingTarget.getAttribute(TARGET_LOCATION);
                super.mouseDown(e, x, y);
                TextFigure textFigure = (TextFigure)this.createdFigure();
                textFigure.setText(Objects.requireNonNullElse(targetLocation, ""));
                this.beginEdit(textFigure);
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.endEdit();
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Deprecated(since="5.0", forRemoval=true)
    protected boolean isTypingActive() {
        return this._typingTarget != null;
    }

    public void beginEdit(TextFigure figure) {
        if (this._textField == null) {
            this._textField = new FloatingTextField();
            this._textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                        TargetTool.this.deactivate();
                        TargetTool.this.editor().toolDone();
                    }
                }
            });
        }
        this._textField.setText(figure.getText());
        this._textField.createOverlay((Container)((Object)this.view()), this.fieldBounds(figure), figure.getFont());
        this.view().remove(figure);
    }

    @Deprecated(since="5.0", forRemoval=true)
    public void setCaretPosition(int line, int col) {
        this._textField.setCaretPosition(line, col);
    }

    public void endEdit() {
        if (this._typingTarget != null) {
            String newText = this._textField.getText();
            String oldText = (String)this._typingTarget.getAttribute(TARGET_LOCATION);
            if (newText.isEmpty()) {
                this._typingTarget.setAttribute(TARGET_LOCATION, null);
            } else {
                try {
                    URI uri;
                    if (!newText.startsWith("sim") && (uri = new URI(newText)).isAbsolute()) {
                        uri.toURL();
                    }
                    this._typingTarget.setAttribute(TARGET_LOCATION, newText);
                }
                catch (Exception e3) {
                    LOGGER.error((Object)("Renaming link failed for : " + newText));
                    LOGGER.debug((Object)e3);
                }
            }
            this._typingTarget = null;
            this._textField.endOverlay();
            this.view().checkDamage();
            if (oldText != null) {
                if (!oldText.equals(newText)) {
                    this.changesMade();
                    this.intermediateUndoSnapshot();
                } else {
                    this.noChangesMade();
                }
            } else if (!newText.isEmpty()) {
                this.changesMade();
                this.intermediateUndoSnapshot();
            } else {
                this.noChangesMade();
            }
        }
    }

    private Rectangle fieldBounds(TextHolder figure) {
        return figure.textDisplayBox();
    }
}

