/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureDrawingContext;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class AbstractFigure
implements ParentFigure {
    public static final Logger LOGGER = Logger.getLogger(AbstractFigure.class);
    public static final Logger GUI_LOGGER = Logger.getLogger((String)"GuiLogger");
    private static final long serialVersionUID = -10857585979273442L;
    private final int _abstractFigureSerializedDataVersion = 1;
    private transient FigureChangeListener _listener;
    private boolean _visible = true;
    protected transient Vector<Figure> children = new Vector();

    protected AbstractFigure() {
        if (GUI_LOGGER.isTraceEnabled()) {
            GUI_LOGGER.trace((Object)("AbstractFigure: created " + String.valueOf(this)));
        }
    }

    @Override
    public void draw(Graphics g, FigureDrawingContext dc) {
        if (dc.isVisible(this)) {
            this.draw(g);
        }
    }

    @Override
    public void moveBy(int dx, int dy) {
        this.willChange();
        this.basicMoveBy(dx, dy);
        FigureEnumeration children = this.children();
        while (children.hasMoreElements()) {
            ((ChildFigure)children.nextElement()).updateLocation();
        }
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    @Override
    public void displayBox(Point origin, Point corner) {
        this.willChange();
        this.basicDisplayBox(origin, corner);
        this.changed();
    }

    @Override
    public void displayBox(Rectangle r) {
        this.displayBox(new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
    }

    @Override
    public abstract Rectangle displayBox();

    @Override
    public abstract void basicDisplayBox(Point var1, Point var2);

    @Override
    public abstract Vector<FigureHandle> handles();

    @Override
    public FigureEnumeration figures() {
        Vector<Figure> figures = new Vector<Figure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    @Override
    public Dimension size() {
        Rectangle box = this.displayBox();
        return new Dimension(box.width, box.height);
    }

    @Override
    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.isVisible()) {
            return this.displayBox().contains(x, y);
        }
        return false;
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public FigureEnumeration decompose() {
        Vector<Figure> figures = new Vector<Figure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    @Override
    public void addToContainer(FigureChangeListener c) {
        this.addFigureChangeListener(c);
        this.invalidate();
    }

    @Override
    public void removeFromContainer(FigureChangeListener c) {
        this.invalidate();
        this.removeFigureChangeListener(c);
        this.changed();
    }

    @Override
    public void addFigureChangeListener(FigureChangeListener l) {
        this._listener = FigureChangeEventMulticaster.add(this._listener, l);
    }

    @Override
    public void removeFigureChangeListener(FigureChangeListener l) {
        this._listener = FigureChangeEventMulticaster.remove(this._listener, l);
    }

    @Override
    public FigureChangeListener listener() {
        return this._listener;
    }

    @Override
    public void release() {
        if (this._listener != null) {
            this._listener.figureRemoved(StorableApi.createFigureChangeEvent(this));
            if (GUI_LOGGER.isTraceEnabled()) {
                GUI_LOGGER.trace((Object)("AbstractFigure: removed " + String.valueOf(this)));
            }
        }
    }

    @Override
    public void invalidate() {
        if (this._listener != null) {
            Rectangle r = this.displayBox();
            Dimension additionalSpace = this.additionalInvalidationSpace();
            r.grow(18 + additionalSpace.width, 18 + additionalSpace.height);
            this._listener.figureInvalidated(StorableApi.createFigureChangeEvent(this, r));
        }
    }

    protected Dimension additionalInvalidationSpace() {
        return new Dimension(0, 0);
    }

    @Override
    public void willChange() {
        this.invalidate();
    }

    @Override
    public void changed() {
        this.invalidate();
        if (this._listener != null) {
            this._listener.figureChanged(StorableApi.createFigureChangeEvent(this));
        }
    }

    public void handlesChanged() {
        if (this._listener != null) {
            this._listener.figureHandlesChanged(StorableApi.createFigureChangeEvent(this));
        }
    }

    @Override
    public Point center() {
        return Geom.center(this.displayBox());
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ChopBoxConnector(this);
    }

    @Override
    public Connector connectorAt(Point p) {
        return this.connectorAt(p.x, p.y);
    }

    @Override
    public void connectorVisibility(boolean isVisible) {
    }

    @Override
    public Locator connectedTextLocator(Figure text) {
        return RelativeLocator.center();
    }

    @Override
    public Object getAttribute(String name) {
        if ("Visibility".equals(name)) {
            return this.isVisible();
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if ("Visibility".equals(name)) {
            this.setVisible((Boolean)value);
        }
    }

    @Override
    public Object clone() {
        Object clone = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeObject(this);
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        try {
            ObjectInputStreamUsingBottomLoader reader = new ObjectInputStreamUsingBottomLoader((InputStream)input);
            clone = reader.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        if (GUI_LOGGER.isTraceEnabled()) {
            GUI_LOGGER.trace((Object)("AbstractFigure: created " + String.valueOf(clone)));
        }
        return clone;
    }

    @Override
    public void write(StorableOutput dw) {
    }

    @Override
    public void read(StorableInput dr) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.children = new Vector();
    }

    @Override
    public FigureEnumeration children() {
        return new FigureEnumerator(this.children);
    }

    @Override
    public void addChild(ChildFigure child) {
        this.children.addElement(child);
        this.addFigureChangeListener(child);
    }

    @Override
    public void removeChild(ChildFigure child) {
        this.children.removeElement(child);
        this.removeFigureChangeListener(child);
    }

    private boolean selectAllChildren(DrawingView view) {
        FigureEnumeration childEnumeration = this.children();
        if (childEnumeration.hasMoreElements()) {
            view.clearSelection();
            view.addToSelectionAll(childEnumeration);
            return true;
        }
        return false;
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        if (!alternate) {
            if (this instanceof ChildFigure) {
                ParentFigure parent = ((ChildFigure)((Object)this)).parent();
                if (parent != null) {
                    view.clearSelection();
                    view.addToSelection(parent);
                    return true;
                }
            } else {
                return this.selectAllChildren(view);
            }
        }
        return false;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        return this.children();
    }

    @Override
    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this._visible = visible;
        this.changed();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }
}

