/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.SmoothPolyLineFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureDrawingContext;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    public static final Logger LOGGER = Logger.getLogger(CompositeFigure.class);
    private static final long serialVersionUID = 7408153435700021866L;
    private final int _compositeFigureSerializedDataVersion = 1;
    protected Vector<Figure> fFigures = new Vector();

    protected CompositeFigure() {
    }

    protected void figureSetChanged() {
    }

    public Figure add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            this.fFigures.addElement(figure);
            figure.addToContainer(this);
        }
        this.figureSetChanged();
        return figure;
    }

    public void addAll(Vector<? extends Figure> newFigures) {
        Enumeration<? extends Figure> k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.add(k.nextElement());
        }
    }

    public Figure remove(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.removeFromContainer(this);
            this.fFigures.removeElement(figure);
            figure.release();
        }
        this.figureSetChanged();
        return figure;
    }

    public void removeAll(Vector<? extends Figure> figures) {
        Enumeration<? extends Figure> k = figures.elements();
        while (k.hasMoreElements()) {
            this.remove(k.nextElement());
        }
    }

    public void removeAll() {
        this.removeAll(new Vector<Figure>(this.fFigures));
    }

    public synchronized Figure orphan(Figure figure) {
        this.fFigures.removeElement(figure);
        this.figureSetChanged();
        return figure;
    }

    public void orphanAll(Vector<? extends Figure> newFigures) {
        Enumeration<? extends Figure> k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.orphan(k.nextElement());
        }
    }

    public synchronized void replace(Figure figure, Figure replacement) {
        int index = this.fFigures.indexOf(figure);
        if (index != -1) {
            replacement.addToContainer(this);
            figure.changed();
            this.fFigures.setElementAt(replacement, index);
        }
        this.figureSetChanged();
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            figure.changed();
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.isVisible()) {
            Rectangle bounds = g.getClipBounds();
            if (bounds != null) {
                bounds.grow(5, 5);
            }
            FigureEnumeration k = this.figures();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Rectangle box = figure.displayBox();
                box.grow(1, 1);
                if (bounds != null && !box.intersects(bounds)) continue;
                figure.draw(g);
            }
        }
    }

    @Override
    public void draw(Graphics g, final FigureDrawingContext dc) {
        if (this.isVisible() && dc.isVisible(this)) {
            final boolean hilighted = dc.isHighlighted(this);
            FigureDrawingContext containerDC = new FigureDrawingContext(){

                @Override
                public boolean isHighlighted(Figure figure) {
                    if (hilighted) {
                        return true;
                    }
                    return dc.isHighlighted(figure);
                }

                @Override
                public boolean isVisible(Figure figure) {
                    return true;
                }

                @Override
                public String expandMacro(String text) {
                    return dc.expandMacro(text);
                }
            };
            Rectangle bounds = g.getClipBounds();
            if (bounds != null) {
                bounds.grow(5, 5);
            }
            FigureEnumeration k = this.figures();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Rectangle box = figure.displayBox();
                box.grow(1, 1);
                if (!dc.isVisible(figure) || bounds != null && !box.intersects(bounds)) continue;
                figure.draw(g, containerDC);
            }
        }
    }

    public Figure figureAt(int i) {
        return this.fFigures.elementAt(i);
    }

    @Override
    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public final FigureEnumeration figuresReverse() {
        return new FilteredFigureEnumerator(new ReverseFigureEnumerator(this.fFigures), Figure::isVisible);
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            fr.grow(1, 1);
            if (!r.intersects(fr)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r, Figure without) {
        if (without == null) {
            return this.findFigure(r);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            fr.grow(1, 1);
            if (!r.intersects(fr) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigure(x, y);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure found;
            Figure figure = k.nextFigure();
            if (figure == without || (found = figure.findFigureInside(x, y)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!f.includes(figure)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int x, int y) throws IllegalStateException {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure;
            Figure parent = figure = k.nextFigure();
            if (figure == null) {
                throw new IllegalStateException();
            }
            while (parent != null) {
                if (parent instanceof ChildFigure) {
                    if ((parent = ((ChildFigure)parent).parent()) == null || !this.includes(parent)) continue;
                    break;
                }
                parent = null;
            }
            if (parent != null) continue;
            figure.moveBy(x, y);
        }
    }

    @Override
    public void release() {
        super.release();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.release();
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(e);
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(StorableApi.createFigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(e);
        }
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fFigures.size());
        Enumeration<Figure> k = this.fFigures.elements();
        while (k.hasMoreElements()) {
            Storable nextElement = k.nextElement();
            if (nextElement instanceof SmoothPolyLineFigure) {
                SmoothPolyLineFigure smoothFigure = (SmoothPolyLineFigure)nextElement;
                nextElement = smoothFigure.getEquivalentPolylineFigure();
            }
            dw.writeStorable(nextElement);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            try {
                this.add((Figure)dr.readStorable());
                continue;
            }
            catch (IOException e) {
                String desc = CompositeFigure.class.getSimpleName() + ": could not read in " + Figure.class.getSimpleName() + " object:";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)desc, (Throwable)e);
                    break;
                }
                LOGGER.error((Object)(desc + " " + String.valueOf(e)));
                break;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.addToContainer(this);
        }
    }

    @Override
    public boolean inspect(DrawingView view, boolean alternate) {
        Point mouse = view.lastClick();
        Figure f = this.findFigure(mouse.x, mouse.y);
        if (f != null && f.inspect(view, alternate)) {
            return true;
        }
        return super.inspect(view, alternate);
    }
}

