/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.AbstractConnector;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class LocatorConnector
extends AbstractConnector {
    public static final int SIZE = 8;
    private static final long serialVersionUID = 5062833203337604181L;
    private final int _locatorConnectorSerializedDataVersion = 1;
    private Locator _locator;

    public LocatorConnector() {
        this._locator = null;
    }

    public LocatorConnector(Figure owner, Locator l) {
        super(owner);
        this._locator = l;
    }

    protected Point locate(ConnectionFigure connection) {
        return this._locator.locate(this.owner());
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    @Override
    public Rectangle displayBox() {
        Point p = this._locator.locate(this.owner());
        return new Rectangle(p.x - 4, p.y - 4, 8, 8);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this._locator);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this._locator = (Locator)dr.readStorable();
    }
}

