/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.SubstringMatcher;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

@Deprecated(since="5.0", forRemoval=true)
public class SearchReplaceFrame {
    public static final int SEARCHMODE = 0;
    public static final int SEARCHREPLACEMODE = 1;
    private Enumeration<Drawing> _drawings;
    private Set<Drawing> _drawingsSet;
    private FigureEnumeration _figures;
    private Drawing _drawing;
    private final JFrame _frame;
    private boolean _stringMatcherValid = false;
    private SubstringMatcher _substringMatcher;
    private final int _mode;
    private boolean _cancelSearchInAllDrawings = true;
    private boolean _searchAll = true;
    private boolean _ignoreCase = true;
    private boolean _newSearch = true;

    public SearchReplaceFrame(int aMode) {
        this._mode = aMode;
        String frameTitle = this._mode == 0 ? "Search" : "Search & Replace";
        this._frame = new JFrame(frameTitle);
        if (!GUIProperties.avoidFrameReshape()) {
            this._frame.setSize(600, 200);
        }
        GridBagLayout gridBag = new GridBagLayout();
        this._frame.getContentPane().setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        JLabel label = new JLabel("Search for:");
        gridBag.setConstraints(label, c);
        this._frame.getContentPane().add(label);
        c.gridwidth = 0;
        JTextField searchTextField = new JTextField("", 30);
        gridBag.setConstraints(searchTextField, c);
        searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SearchReplaceFrame.this.reset();
            }
        });
        this._frame.getContentPane().add(searchTextField);
        JTextField replaceTextField = new JTextField("", 30);
        if (this._mode == 1) {
            c.gridwidth = 1;
            label = new JLabel("Replace with:");
            gridBag.setConstraints(label, c);
            this._frame.getContentPane().add(label);
            c.gridwidth = 0;
            gridBag.setConstraints(replaceTextField, c);
            replaceTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SearchReplaceFrame.this._stringMatcherValid = false;
                }
            });
            this._frame.getContentPane().add(replaceTextField);
        }
        JCheckBox searchAllCheckBox = new JCheckBox("Search all drawings", this._searchAll);
        this._frame.getContentPane().add(searchAllCheckBox);
        searchAllCheckBox.addChangeListener(e -> {
            this._searchAll = !this._searchAll;
            this.reset();
        });
        c.gridwidth = 13;
        gridBag.setConstraints(searchAllCheckBox, c);
        JCheckBox ignoreCaseCheckBox = new JCheckBox("Ignore case", this._ignoreCase);
        this._frame.getContentPane().add(ignoreCaseCheckBox);
        ignoreCaseCheckBox.addChangeListener(e -> {
            this._ignoreCase = !this._ignoreCase;
        });
        c.gridwidth = 0;
        gridBag.setConstraints(ignoreCaseCheckBox, c);
        c.weightx = 1.0;
        String buttonTitle = this._mode == 0 ? "Search" : "Search & Replace";
        JButton searchButton = new JButton(buttonTitle);
        gridBag.setConstraints(searchButton, c);
        this._frame.getContentPane().add(searchButton);
        this._frame.getRootPane().setDefaultButton(searchButton);
        searchButton.addActionListener(e -> {
            if ("".equals(searchTextField.getText())) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!this._stringMatcherValid) {
                this._substringMatcher = this._mode == 0 ? new SubstringMatcher(searchTextField.getText(), null) : new SubstringMatcher(searchTextField.getText(), replaceTextField.getText());
                this._stringMatcherValid = true;
            }
            this.searchInDrawings();
        });
        c.gridwidth = 0;
        JButton cancelButton = new JButton("Cancel");
        gridBag.setConstraints(cancelButton, c);
        this._frame.getContentPane().add(cancelButton);
        cancelButton.addActionListener(e -> this.cancel());
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                SearchReplaceFrame.this._frame.setVisible(false);
                MenuManager.getInstance().getWindowsMenu().removeFrame(SearchReplaceFrame.this._frame);
            }
        });
        this._frame.pack();
        this.reset();
    }

    private void handleFoundFigure(TextFigure foundFigure) {
        if (this._mode == 1) {
            String foundText = foundFigure.getText();
            int nextFromIndex = 0;
            while (this._substringMatcher.matches(foundText, nextFromIndex, this._ignoreCase)) {
                String replacement = this._substringMatcher.replacement(foundText, nextFromIndex);
                int index = this._substringMatcher.indexOf(foundText, nextFromIndex);
                int answer = JOptionPane.showConfirmDialog(this._frame, "Replace:\n" + foundText + "\nwith:\n" + replacement, "Confirm Replacement", 1);
                switch (answer) {
                    case 2: {
                        this.reset();
                        this._cancelSearchInAllDrawings = true;
                        this.setVisible(false);
                        return;
                    }
                    case 0: {
                        DrawApplication application = DrawPlugin.getGui();
                        application.prepareUndoSnapshot();
                        foundFigure.setText(replacement);
                        foundText = replacement;
                        nextFromIndex = index + this._substringMatcher.getReplaceString().length();
                        application.commitUndoSnapshot();
                        application.view().checkDamage();
                        break;
                    }
                    case 1: {
                        nextFromIndex = index + this._substringMatcher.getSearchString().length();
                    }
                }
            }
        }
    }

    private void searchInDrawings() {
        if (this._mode == 1) {
            this.reset();
        } else if (!this._drawing.equals(DrawPlugin.getGui().drawing()) && !this._searchAll) {
            this.reset();
        }
        if (this._mode == 0 && this._searchAll) {
            HashSet<Drawing> currentDrawingsSet = new HashSet<Drawing>();
            Enumeration<Drawing> currentDrawings = DrawPlugin.getGui().drawings();
            while (currentDrawings.hasMoreElements()) {
                currentDrawingsSet.add(currentDrawings.nextElement());
            }
            if (!currentDrawingsSet.equals(this._drawingsSet)) {
                this.reset();
            }
        }
        TextFigure foundFigure = null;
        this._cancelSearchInAllDrawings = false;
        while (!this._cancelSearchInAllDrawings && (this._drawings.hasMoreElements() || this._drawing != null)) {
            if (this._newSearch) {
                this._newSearch = false;
                if (this._drawings.hasMoreElements()) {
                    this._drawing = this._drawings.nextElement();
                    this._figures = this._drawing.figures();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            if ((foundFigure = this.searchInOneDrawing()) != null) {
                FigureException e;
                DrawApplication application = DrawPlugin.getGui();
                if (this._mode == 0) {
                    e = new FigureException("Heureka", 1, this._substringMatcher.getLastPosition() + 1, this._drawing, foundFigure);
                    application.selectOffendingElements(e);
                    return;
                }
                e = new FigureException("Heureka", "", this._drawing, foundFigure);
                application.selectOffendingElements(e);
                this.handleFoundFigure(foundFigure);
                continue;
            }
            this._newSearch = true;
            this._drawing = null;
        }
        if (!this._cancelSearchInAllDrawings && !this._figures.hasMoreElements() & foundFigure == null) {
            Toolkit.getDefaultToolkit().beep();
            this.reset();
        }
    }

    private TextFigure searchInOneDrawing() {
        while (this._figures.hasMoreElements()) {
            TextFigure textFigure;
            String figureText;
            Figure figure = this._figures.nextFigure();
            if (!(figure instanceof TextFigure) || !this._substringMatcher.matches(figureText = (textFigure = (TextFigure)figure).getText(), this._ignoreCase)) continue;
            return textFigure;
        }
        return null;
    }

    protected void reset() {
        DrawApplication application = DrawPlugin.getGui();
        if (application != null) {
            application.tool().deactivate();
            this._drawing = application.drawing();
            if (this._searchAll) {
                this._drawings = application.drawings();
                this._drawingsSet = new HashSet<Drawing>();
                while (this._drawings.hasMoreElements()) {
                    this._drawingsSet.add(this._drawings.nextElement());
                }
                this._drawings = application.drawings();
            } else {
                Vector<Drawing> list = new Vector<Drawing>();
                list.add(this._drawing);
                this._drawings = list.elements();
                this._drawingsSet = new HashSet<Drawing>(list);
            }
            this._figures = this._drawing.figures();
            this._newSearch = true;
            this._stringMatcherValid = false;
        }
    }

    private void cancel() {
        this.setVisible(false);
        DrawPlugin.getGui().toolDone();
    }

    protected void setVisible(boolean b) {
        this._frame.setVisible(b);
        if (b) {
            MenuManager.getInstance().getWindowsMenu().addFrame("Tools", this._frame);
        } else {
            MenuManager.getInstance().getWindowsMenu().removeFrame(this._frame);
        }
    }
}

