/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.AutosaveSaver;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.util.Scheduler;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

@Deprecated(since="5.0", forRemoval=true)
public class AutosaveTask
implements Runnable {
    public static final Logger LOGGER = Logger.getLogger(AutosaveTask.class);
    private final Drawing _drawing;
    private long _lastSaved;
    private long _interval;
    private File _autosaveFilename = null;
    private final AutosaveSaver _saver;

    public AutosaveTask(AutosaveSaver saver, Drawing drawing, long interval) {
        this._saver = saver;
        this._drawing = drawing;
        this._interval = interval;
        this.reset();
        Scheduler.instance().executeIn((Runnable)this, interval);
    }

    private void touch(File filename) {
        try {
            FileOutputStream stream = new FileOutputStream(filename);
            stream.close();
        }
        catch (IOException e) {
            this._interval = 0L;
            LOGGER.debug((Object)("Autosave of drawing " + this._drawing.getName() + " cancelled: " + String.valueOf(e)));
        }
    }

    public synchronized void reset() {
        this._lastSaved = System.currentTimeMillis();
    }

    public synchronized void terminate() {
        this._interval = 0L;
        Scheduler.instance().cancel((Runnable)this);
        if (this._autosaveFilename != null && this._autosaveFilename.exists()) {
            LOGGER.debug((Object)("Deleting autosave copy " + String.valueOf(this._autosaveFilename) + "..."));
            boolean deleted = this._autosaveFilename.delete();
            LOGGER.debug((Object)("Autosave copy " + String.valueOf(this._autosaveFilename) + (deleted ? " was deleted successfully." : " could not be deleted.")));
        }
    }

    @Override
    public synchronized void run() {
        if (this._interval > 0L) {
            long now = System.currentTimeMillis();
            long remainingDelay = this._lastSaved + this._interval - now;
            if (remainingDelay <= 0L) {
                if (this._drawing.isModified()) {
                    if (this._autosaveFilename == null) {
                        File filename = this._drawing.getFilename();
                        if (filename != null) {
                            this._autosaveFilename = new File(StringUtil.stripFilenameExtension((String)filename.getPath()) + ".aut");
                        }
                        if (this._autosaveFilename != null && !this._autosaveFilename.exists()) {
                            this.touch(this._autosaveFilename);
                        } else {
                            this._autosaveFilename = null;
                            for (int i = 0; i < 25 && this._autosaveFilename == null && this._interval > 0L; ++i) {
                                int autosaveNumber = (int)Math.floor(Math.random() * 100000.0);
                                File testFilename = new File("rnw" + autosaveNumber + ".aut");
                                try {
                                    if (!testFilename.createNewFile()) continue;
                                    this._autosaveFilename = testFilename;
                                    continue;
                                }
                                catch (IOException e) {
                                    this._interval = 0L;
                                    LOGGER.debug((Object)("Autosave of drawing " + this._drawing.getName() + " cancelled: " + String.valueOf(e)));
                                }
                            }
                        }
                    }
                    if (this._interval > 0L && this._autosaveFilename != null) {
                        Rectangle rect = this._drawing.displayBox();
                        Dimension size = new Dimension(rect.width + rect.x + 200, rect.height + rect.y + 200);
                        try {
                            LOGGER.debug((Object)("Autosaving drawing " + this._drawing.getName() + " to " + String.valueOf(this._autosaveFilename) + "..."));
                            this._saver.saveAutosaveFile(this._drawing, this._autosaveFilename, new Point(), size);
                        }
                        catch (IOException e) {
                            this._interval = 0L;
                            LOGGER.debug((Object)("Autosave of drawing " + this._drawing.getName() + " cancelled: " + String.valueOf(e)));
                        }
                    }
                }
                this.reset();
            }
            if (this._interval > 0L) {
                Scheduler.instance().executeAt((Runnable)this, this._lastSaved + this._interval);
            }
        }
    }
}

