/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology.exporting;

import de.renew.ioontology.FileFilter;
import de.renew.ioontology.exporting.ExportFormat;
import java.io.File;
import java.util.Objects;

public abstract class ExportFormatAbstract<T>
implements ExportFormat<T> {
    private String _formatName;
    private FileFilter _fileFilter;

    public ExportFormatAbstract(String name) {
        this.setFormatName(name);
    }

    public ExportFormatAbstract(String name, FileFilter fileFilter) {
        this.setFormatName(name);
        this.setFileFilter(fileFilter);
    }

    private void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
        Objects.requireNonNull(fileFilter, "Failure in ExportFormatAbstract: fileFilter() == null");
    }

    private void setFormatName(String formatName) {
        this._formatName = formatName;
        Objects.requireNonNull(this.formatName(), "Failure in ExportFormatAbstract: formatName() == null");
    }

    @Override
    public FileFilter fileFilter() {
        return this._fileFilter;
    }

    @Override
    public String formatName() {
        return this._formatName;
    }

    @Override
    public File[] exportAll(T[] objects, File[] path) throws Exception {
        File[] result = null;
        if (objects != null && path != null && objects.length == path.length) {
            result = new File[path.length];
            for (int pos = 0; pos < objects.length; ++pos) {
                result[pos] = this.export(objects[pos], path[pos]);
            }
        }
        Objects.requireNonNull(result, "Failure in ExportFormatAbstract : result == null");
        return result;
    }

    @Override
    public ExportFormat<T>[] canExport(File path) {
        Objects.requireNonNull(path, "Failure in ExportFormatAbstract: path == null");
        ExportFormat[] result = this.fileFilter().accept(path) ? new ExportFormat[]{this} : new ExportFormat[]{};
        return result;
    }

    @Override
    public int getShortCut() {
        return -1;
    }

    @Override
    public int getModifier() {
        return -1;
    }

    @Override
    public boolean forceGivenName() {
        return false;
    }

    public String toString() {
        return this.formatName();
    }
}

