/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectivePlaceholderList<PerspectiveDockable> dockables = new PerspectivePlaceholderList();
    private PerspectiveDockable selection;
    private PerspectiveStation parent;

    public StackDockPerspective() {
    }

    public StackDockPerspective(PerspectiveDockable[] children, PerspectiveDockable selection) {
        boolean found = false;
        for (PerspectiveDockable child : children) {
            DockUtilities.ensureTreeValidity(this, child);
            child.setParent(this);
            this.dockables.dockables().add(child);
            if (child != selection) continue;
            found = true;
        }
        if (selection != null && !found) {
            throw new IllegalArgumentException("selected dockable is not child of this station");
        }
        this.selection = selection;
    }

    public void read(PlaceholderMap placeholders, final Map<Integer, PerspectiveDockable> children, int selected) {
        PerspectivePlaceholderList<PerspectiveDockable> dockables = new PerspectivePlaceholderList<PerspectiveDockable>();
        dockables.read(placeholders, new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(ConvertedPlaceholderListItem item) {
                if (children == null) {
                    return null;
                }
                int id = item.getInt("id");
                PerspectiveDockable dockable = (PerspectiveDockable)children.get(id);
                if (dockable != null) {
                    dockable.setParent(StackDockPerspective.this);
                }
                return dockable;
            }
        });
        this.dockables = dockables;
        if (children != null) {
            this.selection = children.get(selected);
        }
    }

    public boolean canRead(PlaceholderMap placeholders) {
        return PlaceholderList.PLACEHOLDER_MAP_FORMAT.equals(placeholders.getFormat());
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholders);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap toMap(final Map<PerspectiveDockable, Integer> children) {
        return this.dockables.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, PerspectiveDockable dockable) {
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", (Integer)children.get(dockable));
                item.putInt("index", index);
                Path placeholder = dockable.getPlaceholder();
                if (placeholder != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    public void addPlaceholder(PerspectiveDockable dockable) {
        this.insertPlaceholder(this.getDockableCount(), dockable);
    }

    public void addPlaceholder(Path placeholder) {
        this.insertPlaceholder(this.getDockableCount(), placeholder, PlaceholderList.Level.DOCKABLE);
    }

    public void insertPlaceholder(int index, PerspectiveDockable dockable) {
        this.insertPlaceholder(index, dockable.getPlaceholder(), PlaceholderList.Level.DOCKABLE);
    }

    public void insertPlaceholder(int index, Path placeholder, PlaceholderList.Level level) {
        switch (level) {
            case BASE: {
                this.dockables.list().insertPlaceholder(index, placeholder);
                break;
            }
            case DOCKABLE: {
                this.dockables.dockables().insertPlaceholder(index, placeholder);
                break;
            }
            case PLACEHOLDER: {
                this.dockables.purePlaceholders().insertPlaceholder(index, placeholder);
            }
        }
    }

    public void add(PerspectiveDockable dockable) {
        this.insert(this.getDockableCount(), dockable);
    }

    public void insert(int index, PerspectiveDockable dockable) {
        DockUtilities.ensureTreeValidity(this, dockable);
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockables.dockables().add(index, dockable);
    }

    public int indexOf(PerspectiveDockable dockable) {
        return this.dockables.dockables().indexOf(dockable);
    }

    public int indexOf(Path placeholder) {
        return this.dockables.getDockableIndex(placeholder);
    }

    @Override
    public boolean remove(PerspectiveDockable dockable) {
        int index = this.indexOf(dockable);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public PerspectiveDockable remove(int index) {
        PerspectiveDockable result = (PerspectiveDockable)this.dockables.dockables().get(index);
        this.dockables.remove(result);
        result.setParent(null);
        if (this.selection == result) {
            this.selection = null;
        }
        return result;
    }

    @Override
    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        int index = this.indexOf(oldDockable);
        if (index < 0) {
            throw new IllegalArgumentException("oldDockable is not a child of this station");
        }
        DockUtilities.ensureTreeValidity(this, newDockable);
        boolean selected = this.selection == oldDockable;
        this.remove(index);
        this.insert(index, newDockable);
        if (selected) {
            this.setSelection(newDockable);
        }
    }

    public void setSelection(PerspectiveDockable dockable) {
        if (dockable != null && this.indexOf(dockable) < 0) {
            throw new IllegalArgumentException("dockable is not a child of this station");
        }
        this.selection = dockable;
    }

    public PerspectiveDockable getSelection() {
        return this.selection;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        int index = this.indexOf(child);
        Path placeholder = null;
        placeholder = target != null ? target.getPlaceholder() : child.getPlaceholder();
        return new StackDockProperty(index, placeholder);
    }

    @Override
    public void setParent(PerspectiveStation parent) {
        this.parent = parent;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    @Override
    public PerspectiveDockable getDockable(int index) {
        return (PerspectiveDockable)this.dockables.dockables().get(index);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    public int getItemCount() {
        return this.dockables.list().size();
    }
}

