/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.util.ArrayList;
import java.util.List;

public abstract class ListSpanStrategy {
    private List<Span> spans = new ArrayList<Span>();
    private Span teaser;
    private boolean horizontal = true;
    private DockStation station;
    private StationSpanFactoryValue factory;

    public ListSpanStrategy(String spanFactoryId, DockStation station) {
        this.station = station;
        this.factory = new StationSpanFactoryValue(spanFactoryId, station){

            protected void changed() {
                ListSpanStrategy.this.teaser = null;
                ListSpanStrategy.this.spans.clear();
                ListSpanStrategy.this.reset();
            }
        };
    }

    public void setController(DockController controller) {
        this.factory.setController(controller);
    }

    protected abstract boolean isHorizontal();

    protected abstract int getNumberOfDockables();

    protected abstract void spanResized();

    public void reset() {
        int actual;
        boolean orientation = this.isHorizontal();
        if (orientation != this.horizontal) {
            this.horizontal = orientation;
            this.spans.clear();
            this.teaser = null;
        }
        if (this.teaser == null) {
            this.teaser = this.createSpan(!this.horizontal, SpanUsage.HIDING);
        }
        int requested = this.getNumberOfDockables() + 1;
        for (actual = this.spans.size(); requested > actual; ++actual) {
            this.spans.add(this.createSpan(this.horizontal, SpanUsage.INSERTING));
        }
        while (requested < actual) {
            this.spans.remove(--actual);
        }
        this.teaser.set(SpanMode.OFF);
        for (Span button : this.spans) {
            button.set(SpanMode.OFF);
        }
    }

    private Span createSpan(final boolean horizontal, final SpanUsage usage) {
        return this.factory.create(new SpanCallback(){

            public void resized() {
                ListSpanStrategy.this.spanResized();
            }

            public boolean isVertical() {
                return !this.isHorizontal();
            }

            public boolean isHorizontal() {
                return horizontal;
            }

            public DockStation getStation() {
                return ListSpanStrategy.this.station;
            }

            public SpanUsage getUsage() {
                return usage;
            }
        });
    }

    public void tease(int index) {
        if (this.teaser != null) {
            this.teaser.mutate(SpanMode.TEASING);
        }
        int n = this.spans.size();
        for (int i = 0; i < n; ++i) {
            if (i == index) {
                this.spans.get(i).mutate(SpanMode.OPEN);
                continue;
            }
            this.spans.get(i).mutate(SpanMode.OFF);
        }
    }

    public void size(int index, int size) {
        if (index >= 0 && index < this.spans.size()) {
            this.spans.get(index).configureSize(SpanMode.OPEN, size);
        }
    }

    public void untease() {
        if (this.teaser != null) {
            this.teaser.mutate(SpanMode.OFF);
        }
        for (Span button : this.spans) {
            button.mutate(SpanMode.OFF);
        }
    }

    public int getTeasing() {
        if (this.teaser == null) {
            return 0;
        }
        return this.teaser.getSize();
    }

    public int getGap(int index) {
        if (index >= this.spans.size()) {
            return 0;
        }
        return this.spans.get(index).getSize();
    }
}

