/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen.api;

import de.renew.plugin.ServiceLookupInfrastructure;
import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.splashscreen.proc.Cleanup;
import de.renew.splashscreen.proc.CloseSplashscreen;
import de.renew.splashscreen.proc.PropertyChange;
import de.renew.splashscreen.proc.SequentialProcess;
import de.renew.splashscreen.proc.ShowSplashscreen;
import java.util.HashMap;
import java.util.Map;

public class ProcessInterface {
    private static final Map<String, SequentialProcess> _processLookupTable = new HashMap<String, SequentialProcess>();
    private static final SequentialProcess _showSplashscreen = new ShowSplashscreen();
    private static final SequentialProcess _cleanup = new Cleanup();
    private static final SequentialProcess _propertyChange = new PropertyChange();
    private static final SequentialProcess _closeSplashscreen = new CloseSplashscreen();

    private ProcessInterface() {
    }

    private static void updateLookupTable() {
        if (_processLookupTable.isEmpty()) {
            _processLookupTable.put(_showSplashscreen.getKey(), _showSplashscreen);
            _processLookupTable.put(_cleanup.getKey(), _cleanup);
            _processLookupTable.put(_propertyChange.getKey(), _propertyChange);
            _processLookupTable.put(_closeSplashscreen.getKey(), _closeSplashscreen);
        }
        for (SequentialProcess p : ServiceLookupInfrastructure.getInstance().getAllServiceProvider(SequentialProcess.class)) {
            _processLookupTable.put(p.getKey(), p);
        }
    }

    public static Object executeProcess(String processKey, Object[] args, ISplashscreenPlugin trigger) throws Exception {
        if (!_processLookupTable.containsKey(processKey)) {
            ProcessInterface.updateLookupTable();
            if (!_processLookupTable.containsKey(processKey)) {
                throw new Exception("Process " + processKey + " not found");
            }
        }
        return _processLookupTable.get(processKey).execute(args, trigger);
    }
}

