/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagementgui.gui;

import de.renew.propertymanagement.prop.ConfigurableHotkeyProperty;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotkeyField
extends JTextField {
    private KeyStroke _keyStroke;

    public HotkeyField(final ConfigurableHotkeyProperty property) {
        this.setEditable(false);
        this.setKeyStroke(property.getKeyStroke());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 16 || keyCode == 17 || keyCode == 18 || keyCode == 157) {
                    return;
                }
                int modifiers = e.getModifiersEx();
                HotkeyField.this.setKeyStroke(KeyStroke.getKeyStroke(keyCode, modifiers));
                ConfigurablePropertyManager.getInstance().changeHotkeyProperty(property.getKey(), HotkeyField.this._keyStroke);
            }
        });
    }

    private void setKeyStroke(KeyStroke ks) {
        this._keyStroke = ks;
        this.setText(this.getFormattedKeyStroke());
    }

    private String getFormattedKeyStroke() {
        if (this._keyStroke == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int mod = this._keyStroke.getModifiers();
        if ((mod & 0x80) != 0) {
            sb.append("Ctrl+");
        }
        if ((mod & 0x40) != 0) {
            sb.append("Shift+");
        }
        if ((mod & 0x200) != 0) {
            sb.append("Alt+");
        }
        if ((mod & 0x100) != 0) {
            sb.append("Meta+");
        }
        sb.append(KeyEvent.getKeyText(this._keyStroke.getKeyCode()));
        return sb.toString();
    }
}

