/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.action.panel;

import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.action.panel.AbstractPanelPopupWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DialogWindow
extends AbstractPanelPopupWindow {
    private JDialog dialog;
    private CPanelPopup panel;
    private WindowListener listener = new WindowAdapter(){

        public void windowClosed(WindowEvent e) {
            DialogWindow.this.closing();
        }

        public void windowClosing(WindowEvent e) {
            DialogWindow.this.closing();
        }

        public void windowDeactivated(WindowEvent e) {
            if (DialogWindow.this.panel.isCloseOnFocusLost()) {
                DialogWindow.this.close();
            }
        }
    };

    public DialogWindow(Component owner, CPanelPopup panel) {
        this.panel = panel;
        this.dialog = this.createDialog(owner);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.listener);
    }

    public void setUndecorated(boolean undecorated) {
        this.dialog.setUndecorated(undecorated);
    }

    public void setContent(Component content) {
        this.dialog.getContentPane().removeAll();
        if (content != null) {
            this.dialog.add(content);
        }
    }

    public void open(int x, int y) {
        this.dialog.pack();
        this.dialog.setLocation(x, y);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    public void open(Component relativeTo) {
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(relativeTo);
        this.validateBounds();
        this.dialog.setVisible(true);
    }

    private void validateBounds() {
        Rectangle bounds = this.dialog.getBounds();
        Point location = this.dialog.getLocation();
        GraphicsConfiguration bestConfiguration = null;
        int bestDistance = 0;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : environment.getScreenDevices()) {
            int dy;
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Rectangle screenBounds = configuration.getBounds();
            if (screenBounds.contains(location)) {
                bestConfiguration = configuration;
                bestDistance = 0;
                continue;
            }
            int dx = screenBounds.x <= location.x && screenBounds.x + screenBounds.width >= location.x ? 0 : Math.min(Math.abs(screenBounds.x - location.x), Math.abs(screenBounds.x + screenBounds.width - location.x));
            int delta = dx + (dy = screenBounds.y <= location.y && screenBounds.y + screenBounds.height >= location.y ? 0 : Math.min(Math.abs(screenBounds.y - location.y), Math.abs(screenBounds.y + screenBounds.height - location.y)));
            if (delta >= bestDistance && bestConfiguration != null) continue;
            bestDistance = delta;
            bestConfiguration = configuration;
        }
        if ((bounds = this.validateBounds(bounds, bestConfiguration)) != null) {
            this.dialog.setBounds(bounds);
        }
    }

    public boolean isOpen() {
        return this.dialog.isVisible();
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    private void closing() {
        this.dialog.dispose();
        this.dialog.removeWindowListener(this.listener);
        this.fireClosed();
    }

    protected JDialog createDialog(Component owner) {
        Window window = SwingUtilities.getWindowAncestor(owner);
        if (window instanceof Frame) {
            return new JDialog((Frame)window);
        }
        if (window instanceof Dialog) {
            return new JDialog((Dialog)window);
        }
        return new JDialog();
    }
}

