/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExtendedProgressBar
extends JPanel {
    private JScrollPane _scrollPane;
    private static ExtendedProgressBar _extendedProgressBar;
    private static final int PROGRESS_MAX_VALUE = 100;
    private static final int SPACE_BETWEEN_COMPONENTS = 5;
    private static final int TEXTAREA_ROWS = 10;
    private static final int TEXTAREA_COLUMNS = 30;
    private static final int FONT_SIZE = 14;
    private static final String LOADED_INFO_SCROLL_PANE = "loadedInfoScrollPane";
    private static final String LOADED_INFO_TEXT_AREA = "loadedInfoTextArea";
    private JProgressBar _progressBar;
    private JTextArea _textArea;

    private ExtendedProgressBar() {
        if (_extendedProgressBar == null) {
            this.init();
        }
    }

    public static synchronized ExtendedProgressBar getInstance() {
        if (_extendedProgressBar == null) {
            _extendedProgressBar = new ExtendedProgressBar();
        }
        return _extendedProgressBar;
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this._textArea = new JTextArea(10, 30);
        this._textArea.setName(LOADED_INFO_TEXT_AREA);
        this._scrollPane = new JScrollPane(this._textArea);
        this._scrollPane.setName(LOADED_INFO_SCROLL_PANE);
        this._scrollPane.setAutoscrolls(true);
        this._textArea.setEditable(false);
        Font font = new Font("Arial", 1, 14);
        this._textArea.setFont(font);
        this._textArea.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this._scrollPane.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.add(this._scrollPane);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this._progressBar.setAlignmentY(0.5f);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this._progressBar);
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            if (progress > 100) {
                progress = 100;
            }
            this._progressBar.setValue(progress);
            this._progressBar.validate();
        }
        if ("pluginLoaded".equals(evt.getPropertyName())) {
            String tmp = "Loaded plugin : " + String.valueOf(evt.getNewValue()) + "\n";
            this._textArea.append(tmp);
            this._textArea.setCaretPosition(this._textArea.getCaretPosition() + tmp.length());
        }
    }

    void closeExtendedProgressBar() {
        this.remove(this._progressBar);
        this.remove(this._scrollPane);
        this.remove(this._textArea);
        this._progressBar = null;
        this._scrollPane = null;
        this._textArea = null;
        _extendedProgressBar = null;
        this.validate();
    }
}

