/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.framework.UndoableCommand;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.FigureFilter;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.ArcConnection;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.util.HashSet;
import java.util.Set;

public class CoarseCommand
extends UndoableCommand {
    public CoarseCommand(String name) {
        super(name);
    }

    public boolean executeUndoable() {
        if (this.isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            Drawing drawing = EditorApi.getCurrentDrawing();
            DrawingView view = this.getEditor().view();
            FigureEnumeration selected = view.selectionElements();
            int i = 1;
            FigureEnumeration borderFigures = StorableApi.createFilteredFigureEnumerator((FigureEnumeration)selected, new BorderFigureFilter()::isAcceptedFigure);
            HashSet<Figure> borderSet = new HashSet<Figure>();
            NodeFigure finalFig = (NodeFigure)borderFigures.nextFigure();
            borderSet.add(finalFig);
            while (borderFigures.hasMoreElements()) {
                borderSet.add(borderFigures.nextFigure());
            }
            selected = view.selectionElements();
            int finalx = finalFig.center().x;
            int finaly = finalFig.center().y;
            while (selected.hasMoreElements()) {
                Figure nextFig = selected.nextFigure();
                if (nextFig.equals(finalFig) || !(nextFig instanceof TransitionFigure) && !(nextFig instanceof PlaceFigure)) continue;
                FigureEnumeration figures = drawing.figures();
                while (figures.hasMoreElements()) {
                    Figure fig = figures.nextFigure();
                    if (!(fig instanceof ArcConnection)) continue;
                    ArcConnection arc = (ArcConnection)fig;
                    if (arc.startFigure().equals(nextFig)) {
                        if (borderSet.contains(nextFig)) {
                            arc.disconnectStart();
                            arc.connectStart(finalFig.connectorAt(finalFig.center().x, finalFig.center().y));
                            arc.updateConnection();
                        } else {
                            view.remove((Figure)arc);
                        }
                    }
                    if (!arc.endFigure().equals(nextFig)) continue;
                    if (borderSet.contains(nextFig)) {
                        arc.disconnectEnd();
                        arc.connectEnd(finalFig.connectorAt(finalFig.center().x, finalFig.center().y));
                        arc.updateConnection();
                        continue;
                    }
                    view.remove((Figure)arc);
                }
                if (nextFig instanceof TransitionFigure && finalFig instanceof TransitionFigure || nextFig instanceof PlaceFigure && finalFig instanceof PlaceFigure) {
                    ParentFigure parent = (ParentFigure)nextFig;
                    while (parent.children().hasMoreElements()) {
                        ChildFigure fig = (ChildFigure)parent.children().nextFigure();
                        fig.setParent((ParentFigure)finalFig);
                        drawing.bringToFront((Figure)fig);
                    }
                }
                ++i;
                finalx += nextFig.center().x;
                finaly += nextFig.center().y;
                view.remove(nextFig);
            }
            finalFig.moveBy((finalx /= i) - finalFig.center().x, (finaly /= i) - finalFig.center().y);
            view.checkDamage();
            return true;
        }
        return false;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        DrawingView view = this.getEditor().view();
        FigureEnumeration selected = view.selectionElements();
        FigureEnumeration borderFigures = StorableApi.createFilteredFigureEnumerator((FigureEnumeration)selected, new BorderFigureFilter()::isAcceptedFigure);
        Figure firstFig = borderFigures.nextFigure();
        if (firstFig instanceof TransitionFigure) {
            while (borderFigures.hasMoreElements()) {
                if (borderFigures.nextFigure() instanceof TransitionFigure) continue;
                return false;
            }
            return true;
        }
        if (firstFig instanceof PlaceFigure) {
            while (borderFigures.hasMoreElements()) {
                if (borderFigures.nextFigure() instanceof PlaceFigure) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    class BorderFigureFilter
    implements FigureFilter {
        final Set<Figure> selectedSet;

        public BorderFigureFilter() {
            DrawingView view = CoarseCommand.this.getEditor().view();
            FigureEnumeration selected = view.selectionElements();
            this.selectedSet = new HashSet<Figure>();
            while (selected.hasMoreElements()) {
                this.selectedSet.add(selected.nextFigure());
            }
        }

        public boolean isAcceptedFigure(Figure figure) {
            if (figure instanceof TransitionFigure || figure instanceof PlaceFigure) {
                FigureEnumeration figures = EditorApi.getCurrentDrawing().figures();
                while (figures.hasMoreElements()) {
                    ArcConnection arc;
                    Figure fig = figures.nextFigure();
                    if (!(fig instanceof ArcConnection) || (!(arc = (ArcConnection)fig).startFigure().equals(figure) || this.selectedSet.contains(arc.endFigure())) && (!arc.endFigure().equals(figure) || this.selectedSet.contains(arc.startFigure()))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

