/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.configure.ConfigureEngineTab;
import de.renew.plugin.PropertyHelper;
import java.awt.Component;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigureEngineController
implements ConfigureSimulationTabController {
    private static final Logger logger = Logger.getLogger(ConfigureEngineController.class);
    private final ConfigureEngineTab tab = new ConfigureEngineTab();

    @Override
    public Component getTab() {
        return this.tab;
    }

    @Override
    public void commitTab(Properties props) {
        boolean sequential = this.tab.getSequential();
        int mult = Math.abs(Integer.parseInt(this.tab.getMultiplicity()));
        if (mult == 0) {
            mult = 1;
        }
        if (sequential) {
            mult = -mult;
        }
        if (mult == 1) {
            props.remove("de.renew.simulatorMode");
            logger.debug((Object)"ConfigureEngineController: Configured simulatorMode=null.");
        } else {
            props.setProperty("de.renew.simulatorMode", Integer.toString(mult));
            logger.debug((Object)("ConfigureEngineController: Configured simulatorMode=" + mult + "."));
        }
        mult = Math.abs(Integer.parseInt(this.tab.getPriority()));
        if (mult == 0) {
            mult = 1;
        }
        if (mult >= 10) {
            mult = 9;
        }
        props.setProperty("de.renew.simulatorPriority", Integer.toString(mult));
        boolean classReinit = this.tab.getClassReinit();
        props.setProperty("de.renew.classReinit", Boolean.toString(classReinit));
        logger.debug((Object)("ConfigureEngineController: Configured classReinit=" + classReinit + "."));
        boolean eagerSimulation = this.tab.getEagerSimulation();
        props.setProperty("de.renew.eagerSimulation", Boolean.toString(eagerSimulation));
        logger.debug((Object)("ConfigureEngineController: Configured eagerSimulation=" + eagerSimulation + "."));
    }

    @Override
    public void updateTab(Properties props) {
        boolean sequential;
        int mult = PropertyHelper.getIntProperty((Properties)props, (String)"de.renew.simulatorMode", (int)1);
        boolean bl = sequential = mult < 0;
        if (sequential) {
            mult = -mult;
        }
        this.tab.setSequential(sequential);
        this.tab.setMultiplicity(Integer.toString(mult));
        mult = PropertyHelper.getIntProperty((Properties)props, (String)"de.renew.simulatorPriority", (int)5);
        this.tab.setPriority(Integer.toString(mult));
        boolean classReinit = PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.classReinit");
        this.tab.setClassReinit(classReinit);
        boolean eagerSimulation = PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.eagerSimulation");
        this.tab.setEagerSimulation(eagerSimulation);
    }
}

