/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.nin.CheckboxListCellRenderer;
import de.renew.gui.nin.CustomCompositionPanel;
import de.renew.gui.nin.FormattedNumberTextField;
import de.renew.gui.nin.SystemNetBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ConstructionGUI
extends JFrame {
    private static final String FRAME_NAME = "Settings for System Net Creation";
    private final JPanel container;
    private final SystemNetBuilder netBuilder;
    boolean[] options;
    private DefaultListModel<String> model;
    private Map<Integer, Set<String>> channelsForOption;
    private Map<JCheckBox, Object[]> netInstanceSelectionMap;

    public ConstructionGUI(CPNApplication app) {
        super(FRAME_NAME);
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.addCheckBoxesToContainer(app.drawings().asIterator());
        JScrollPane scrollPane = new JScrollPane(this.container);
        Dimension dimension = this.container.getPreferredSize();
        dimension.width = dimension.width < 700 ? dimension.width + 50 : 700;
        dimension.height = dimension.height < 600 ? dimension.height + 50 : 600;
        scrollPane.setPreferredSize(dimension);
        JOptionPane.showConfirmDialog(this, scrollPane, "Select System Net Options", -1);
        HashMap<Drawing, Integer> drawingsToConsider = new HashMap<Drawing, Integer>();
        for (JCheckBox box : this.netInstanceSelectionMap.keySet()) {
            if (!box.isSelected()) continue;
            Object[] values = this.netInstanceSelectionMap.get(box);
            drawingsToConsider.put((Drawing)values[0], (Integer)((JFormattedTextField)values[1]).getValue());
        }
        this.netBuilder = new SystemNetBuilder(drawingsToConsider, this.options, this.channelsForOption, this.model);
    }

    private void addCheckBoxesToContainer(Iterator<Drawing> drawings) {
        HashSet<Drawing> originalDrawings = new HashSet<Drawing>();
        drawings.forEachRemaining(originalDrawings::add);
        this.addNetSelectionPanel(originalDrawings);
        Set<String> channelNames = this.parseChannelNames(originalDrawings);
        this.options = new boolean[3];
        this.channelsForOption = new HashMap<Integer, Set<String>>();
        this.addOptionPanel(channelNames, "Multiple Instances", "Synchronize two instances via selected channels", "Adds channels in the form of \"NetA:sync();NetB:sync()\"", 0, true);
        this.addCustomCompositionPanel(channelNames);
    }

    private void addCustomCompositionPanel(Set<String> channelNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Custom Compositions"));
        Dimension dimension = this.container.getPreferredSize();
        dimension.height = dimension.width < 100 ? dimension.width + 50 : 150;
        panel.setPreferredSize(dimension);
        this.model = new DefaultListModel();
        JList<String> list = new JList<String>(this.model);
        panel.add((Component)new JScrollPane(list), "Center");
        JPanel buttonpanel = new JPanel();
        String title = "Add custom composition";
        JButton addNewButton = new JButton(title);
        this.addCustomCompositionBehaviorToButton(addNewButton, panel, title, channelNames, this.model);
        buttonpanel.setLayout(new BorderLayout());
        buttonpanel.add((Component)addNewButton, "Center");
        JButton removeCustomCompButton = new JButton("-");
        removeCustomCompButton.addActionListener(e -> {
            if (!list.isSelectionEmpty()) {
                this.model.remove(list.getSelectedIndex());
            }
        });
        buttonpanel.add((Component)removeCustomCompButton, "East");
        panel.add((Component)buttonpanel, "South");
        this.container.add(panel);
    }

    private void addCustomCompositionBehaviorToButton(JButton addNewButton, JPanel panel, String title, Set<String> channelNames, DefaultListModel<String> model) {
        addNewButton.addActionListener(e -> {
            int netNumber = 0;
            for (JCheckBox box : this.netInstanceSelectionMap.keySet()) {
                if (!box.isSelected()) continue;
                Object[] values = this.netInstanceSelectionMap.get(box);
                netNumber += ((Integer)((JFormattedTextField)values[1]).getValue()).intValue();
            }
            Map<String, Map<String, FormattedNumberTextField>> compSelectionMap = CustomCompositionPanel.showConfirmDialog(panel, title, channelNames, netNumber);
            StringBuilder newComposition = new StringBuilder();
            for (String net : compSelectionMap.keySet()) {
                Map<String, FormattedNumberTextField> channelMap = compSelectionMap.get(net);
                if (!this.netHasNonZeroEntries(channelMap)) continue;
                newComposition.append("this:getReference(").append(net).append(");\n");
                for (String channel : channelMap.keySet()) {
                    Integer channelValue = (Integer)channelMap.get(channel).getValue();
                    if (channelValue <= 0) continue;
                    for (int i = 0; i < channelValue; ++i) {
                        newComposition.append(net).append(channel).append(";\n");
                    }
                }
            }
            if (!String.valueOf(newComposition).isBlank()) {
                model.addElement(String.valueOf(newComposition));
            }
        });
    }

    private boolean netHasNonZeroEntries(Map<String, FormattedNumberTextField> channelMap) {
        for (String channel : channelMap.keySet()) {
            if ((Integer)channelMap.get(channel).getValue() == 0) continue;
            return true;
        }
        return false;
    }

    private void addNetSelectionPanel(Set<Drawing> originalDrawings) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Select Nets"));
        this.netInstanceSelectionMap = new HashMap<JCheckBox, Object[]>();
        int netCounter = 0;
        for (Drawing drawing : originalDrawings) {
            panel.add(this.netInstanceSelectionPanel(drawing, netCounter));
            ++netCounter;
        }
        this.container.add(panel);
    }

    JPanel netInstanceSelectionPanel(Drawing drawing, int netCounter) {
        JPanel container = new JPanel();
        String title = "Net " + netCounter;
        container.setBorder(new TitledBorder(title));
        container.setLayout(new GridBagLayout());
        FormattedNumberTextField numberOfInstances = new FormattedNumberTextField(1);
        JCheckBox box = new JCheckBox(drawing.getName());
        box.setSelected(true);
        Object[] values = new Object[]{drawing, numberOfInstances};
        this.netInstanceSelectionMap.put(box, values);
        container.add(box);
        container.add(numberOfInstances);
        return container;
    }

    private Set<String> parseChannelNames(Set<Drawing> drawings) {
        HashSet<String> channelNames = new HashSet<String>();
        Pattern pattern = Pattern.compile("(:.*\\()(.*)(\\))");
        for (Drawing drawing : drawings) {
            FigureEnumeration figureEnumerator = drawing.figures();
            while (figureEnumerator.hasMoreElements()) {
                CPNTextFigure textFigure;
                Matcher m;
                Figure drawingFigure = figureEnumerator.nextFigure();
                if (!(drawingFigure instanceof CPNTextFigure) || !(m = pattern.matcher((textFigure = (CPNTextFigure)drawingFigure).getText())).find()) continue;
                channelNames.add(m.group(1) + this.buildVariableText(m.group(2)) + m.group(3));
            }
        }
        return channelNames;
    }

    private String buildVariableText(String parameterString) {
        if (parameterString.isBlank()) {
            return "";
        }
        String[] parameterArray = parameterString.strip().split(",");
        StringBuilder parameterText = new StringBuilder();
        for (int i = 0; i < parameterArray.length; ++i) {
            parameterText.append("var").append(i);
            if (i >= parameterArray.length - 1) continue;
            parameterText.append(", ");
        }
        return String.valueOf(parameterText);
    }

    private void addOptionPanel(Set<String> channelNames, String panelTitle, String boxTitle, String tooltip, int index, boolean selected) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(panelTitle));
        JCheckBox box = this.buildCheckBoxOption(index, selected, boxTitle);
        box.setToolTipText(tooltip);
        panel.add((Component)box, "West");
        JList<String> list = this.buildChannelSelectionList(channelNames, index, true);
        panel.add(list, "East");
        list.setEnabled(box.isSelected());
        box.addActionListener(e -> {
            if (box.isSelected()) {
                list.setEnabled(true);
                this.channelsForOption.put(index, new HashSet(list.getSelectedValuesList()));
            } else {
                list.setEnabled(false);
                this.channelsForOption.put(index, new HashSet());
            }
        });
        this.container.add(panel);
    }

    private JList<String> buildChannelSelectionList(Set<String> channelNames, int index, boolean selected) {
        JList<String> list = new JList<String>((String[])channelNames.toArray(String[]::new));
        list.setCellRenderer(new CheckboxListCellRenderer());
        TitledBorder title = BorderFactory.createTitledBorder(LineBorder.createBlackLineBorder(), "Select Channels");
        title.setTitleJustification(2);
        list.setBorder(title);
        list.setSelectionMode(2);
        list.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (super.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
        this.channelsForOption.put(index, channelNames);
        list.addListSelectionListener(e -> this.channelsForOption.put(index, new HashSet(list.getSelectedValuesList())));
        if (selected) {
            list.setSelectionInterval(0, channelNames.size() - 1);
        }
        return list;
    }

    private JCheckBox buildCheckBoxOption(int index, boolean selected, String title) {
        JCheckBox checkBox = new JCheckBox(title);
        checkBox.addItemListener(e -> {
            this.options[index] = checkBox.isSelected();
        });
        checkBox.setSelected(selected);
        return checkBox;
    }

    public SystemNetBuilder getNetBuilder() {
        return this.netBuilder;
    }
}

