/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.nin;

import CH.ifa.draw.framework.ChildFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.nin.PTCNetInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PTCTransitionBuilder {
    private static final Logger logger = Logger.getLogger(PTCTransitionBuilder.class);
    private final Drawing drawingToModify;
    private final PTCNetInformation netInformation;

    public PTCTransitionBuilder(Drawing drawingToAddTransitionsTo, PTCNetInformation netInformation) {
        this.drawingToModify = drawingToAddTransitionsTo;
        this.netInformation = netInformation;
    }

    public void buildTransitionIfBindingIsPossible(TransitionFigure uplinkTransition, TransitionFigure partnerTransition) {
        CPNTextFigure uplinkText = this.netInformation.getInitialTransitionInscriptions().get(uplinkTransition);
        Optional<List<String>> params = this.getChannelTransitionTextValues(uplinkText);
        CPNTextFigure partnerText = this.netInformation.getInitialTransitionInscriptions().get(partnerTransition);
        Optional<List<String>> partnerParams = this.getChannelTransitionTextValues(partnerText);
        if (params.isPresent() && partnerParams.isPresent()) {
            if (params.get().isEmpty() && partnerParams.get().isEmpty()) {
                this.buildTransition(uplinkTransition, partnerTransition, new HashMap<String, Integer>(), this.drawingToModify);
            } else {
                Map<String, Integer> bindings = this.bindingMap(partnerParams.get(), params.get());
                if (bindings != null) {
                    this.buildTransition(uplinkTransition, partnerTransition, bindings, this.drawingToModify);
                }
            }
        } else {
            logger.error((Object)"Could not read channel parameters.");
        }
    }

    private void buildTransition(TransitionFigure uplinkFigure, TransitionFigure downlinkFigure, Map<String, Integer> parameterBindings, Drawing netdrawing) {
        TransitionFigure t = (TransitionFigure)downlinkFigure.clone();
        this.addArcsForIncomingArcs(downlinkFigure, t, netdrawing, parameterBindings);
        this.addArcsForIncomingArcs(uplinkFigure, t, netdrawing, parameterBindings);
        this.addArcsForOutgoingArcs(downlinkFigure, t, netdrawing, parameterBindings);
        this.addArcsForOutgoingArcs(uplinkFigure, t, netdrawing, parameterBindings);
        netdrawing.add((Figure)t);
        netdrawing.checkDamage();
    }

    private void addArcsForIncomingArcs(TransitionFigure oldTransition, TransitionFigure newTransition, Drawing netdrawing, Map<String, Integer> parameterBindings) {
        for (ArcConnection arc : this.netInformation.getIncomingArcs(oldTransition)) {
            String[] arcInscriptions = this.getArcInscriptionVariables(this.netInformation.getInitialArcInscriptions().get(arc));
            if (parameterBindings.isEmpty() || arcInscriptions == null) {
                this.addIncomingArc(arc, newTransition, netdrawing);
                continue;
            }
            for (String variable : parameterBindings.keySet()) {
                for (String arcInscription : arcInscriptions) {
                    if (!variable.equals(arcInscription)) continue;
                    this.addIncomingArcWithInscription(arc, parameterBindings.get(variable), newTransition, netdrawing);
                }
            }
        }
    }

    private void addIncomingArcWithInscription(ArcConnection arc, Integer parameterValue, TransitionFigure newTransition, Drawing netdrawing) {
        if (parameterValue == 0) {
            return;
        }
        ArcConnection addedArc = (ArcConnection)arc.clone();
        addedArc.connectStart(arc.start());
        addedArc.connectEnd(newTransition.connectorAt(newTransition.center()));
        netdrawing.add((Figure)addedArc);
        if (parameterValue != 1) {
            CPNTextFigure inscription = new CPNTextFigure(1);
            inscription.setText(Integer.toString(parameterValue));
            this.addInscription(inscription, addedArc, netdrawing);
        }
    }

    private void addArcsForOutgoingArcs(TransitionFigure oldTransition, TransitionFigure newTransition, Drawing netdrawing, Map<String, Integer> parameterBindings) {
        for (ArcConnection arc : this.netInformation.getOutgoingArcs(oldTransition)) {
            String[] arcInscriptions = this.getArcInscriptionVariables(this.netInformation.getInitialArcInscriptions().get(arc));
            if (parameterBindings.isEmpty() || arcInscriptions == null) {
                this.addOutgoingArc(arc, newTransition, netdrawing);
                continue;
            }
            for (String variable : parameterBindings.keySet()) {
                for (String arcInscription : arcInscriptions) {
                    if (!variable.equals(arcInscription)) continue;
                    this.addOutgoingArcWithInscription(arc, parameterBindings.get(variable), newTransition, netdrawing);
                }
            }
        }
    }

    private void addOutgoingArc(ArcConnection arc, TransitionFigure transition, Drawing drawing) {
        ArcConnection addedArc = (ArcConnection)arc.clone();
        addedArc.connectEnd(arc.end());
        addedArc.connectStart(transition.connectorAt(transition.center()));
        drawing.add((Figure)addedArc);
        CPNTextFigure text = this.netInformation.getInitialArcInscriptions().get(arc);
        if (text != null) {
            this.addInscription(text, addedArc, drawing);
        }
    }

    private void addOutgoingArcWithInscription(ArcConnection arc, int parameterValue, TransitionFigure uplinkFigure, Drawing drawing) {
        if (parameterValue == 0) {
            return;
        }
        ArcConnection addedArc = (ArcConnection)arc.clone();
        addedArc.connectEnd(arc.end());
        addedArc.connectStart(uplinkFigure.connectorAt(uplinkFigure.center()));
        drawing.add((Figure)addedArc);
        if (parameterValue != 1) {
            CPNTextFigure inscription = new CPNTextFigure(1);
            inscription.setText(Integer.toString(parameterValue));
            this.addInscription(inscription, addedArc, drawing);
        }
    }

    private void addIncomingArc(ArcConnection arc, TransitionFigure transition, Drawing drawing) {
        ArcConnection addedArc = (ArcConnection)arc.clone();
        addedArc.connectStart(arc.start());
        addedArc.connectEnd(transition.connectorAt(transition.center()));
        drawing.add((Figure)addedArc);
        CPNTextFigure text = this.netInformation.getInitialArcInscriptions().get(arc);
        if (text != null) {
            this.addInscription(text, addedArc, drawing);
        }
    }

    private void addInscription(CPNTextFigure text, ArcConnection newArc, Drawing drawing) {
        CPNTextFigure inscription = (CPNTextFigure)text.clone();
        drawing.add((Figure)inscription);
        newArc.addChild((ChildFigure)inscription);
        inscription.setParent(newArc);
    }

    private Map<String, Integer> bindingMap(List<String> downlinkParameters, List<String> uplinkParameters) {
        if (downlinkParameters.size() != uplinkParameters.size()) {
            return null;
        }
        HashMap<String, Integer> numbersOfVariableParameters = new HashMap<String, Integer>();
        Pattern pattern = Pattern.compile("\\d+");
        for (int i = 0; i < downlinkParameters.size(); ++i) {
            if (pattern.matcher(downlinkParameters.get(i)).matches()) {
                if (pattern.matcher(uplinkParameters.get(i)).matches()) {
                    return null;
                }
                numbersOfVariableParameters.put(uplinkParameters.get(i), Integer.parseInt(downlinkParameters.get(i)));
                continue;
            }
            if (pattern.matcher(uplinkParameters.get(i)).matches()) {
                numbersOfVariableParameters.put(downlinkParameters.get(i), Integer.parseInt(uplinkParameters.get(i)));
                continue;
            }
            return null;
        }
        return numbersOfVariableParameters;
    }

    private String[] getArcInscriptionVariables(CPNTextFigure text) {
        try {
            ArrayList<String> variables = new ArrayList<String>();
            for (String line : text.getLines()) {
                String[] variableLine = line.trim().split(";");
                variables.addAll(List.of(variableLine));
            }
            return (String[])variables.toArray(String[]::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Optional<List<String>> getChannelTransitionTextValues(CPNTextFigure text) {
        try {
            ArrayList<String> variables = new ArrayList<String>();
            for (String line : text.getLines()) {
                if ((line = line.substring(line.indexOf("(") + 1, line.indexOf(")"))).isBlank()) {
                    return Optional.of(variables);
                }
                String[] variableInLine = line.split(",");
                Arrays.parallelSetAll(variableInLine, i -> variableInLine[i].trim());
                variables.addAll(List.of(variableInLine));
            }
            return Optional.of(variables);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

