/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.Serializable;

public class ID
implements Serializable {
    private final int[] _seq;
    private int _hash;

    private ID(int[] seq) {
        this._seq = seq;
        this._hash = 637;
        for (int j : seq) {
            this._hash = this._hash * 59 + j;
        }
    }

    public static ID create(int num) {
        return new ID(new int[]{num});
    }

    public static ID create(int num1, int num2) {
        return new ID(new int[]{num1, num2});
    }

    public static ID create(int num1, int num2, int num3) {
        return new ID(new int[]{num1, num2, num3});
    }

    public static ID create(int[] seq) {
        return new ID((int[])seq.clone());
    }

    public ID appending(int num) {
        int[] newSeq = new int[this._seq.length + 1];
        System.arraycopy(this._seq, 0, newSeq, 0, this._seq.length);
        newSeq[this._seq.length] = num;
        return new ID(newSeq);
    }

    public ID appending(ID id) {
        return this.appending(id._seq);
    }

    public ID appending(int[] app) {
        int[] newSeq = new int[this._seq.length + app.length];
        System.arraycopy(this._seq, 0, newSeq, 0, this._seq.length);
        System.arraycopy(this._seq, 0, newSeq, this._seq.length, app.length);
        return new ID(newSeq);
    }

    public ID clipped() {
        if (this._seq.length == 0) {
            throw new RuntimeException("Cannot clip: ID already empty.");
        }
        int[] newSeq = new int[this._seq.length - 1];
        System.arraycopy(this._seq, 0, newSeq, 0, this._seq.length - 1);
        return new ID(newSeq);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ID) {
            ID that = (ID)obj;
            if (that._seq.length == this._seq.length) {
                for (int i = 0; i < this._seq.length; ++i) {
                    if (that._seq[i] == this._seq[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this._hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this._seq.length; ++i) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(this._seq[i]);
        }
        return buf.toString();
    }
}

