/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import de.renew.util.DelayedField;
import de.renew.util.ObjectInputStreamUsingBottomLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;

public class RenewObjectInputStream
extends ObjectInputStreamUsingBottomLoader {
    private final boolean _copiousBehaviour;

    public RenewObjectInputStream(InputStream in) throws IOException {
        this(in, false);
    }

    public RenewObjectInputStream(InputStream in, boolean copiousBehaviour) throws IOException {
        super(in);
        this._copiousBehaviour = copiousBehaviour;
    }

    public boolean isCopiousBehaviour() {
        return this._copiousBehaviour;
    }

    public void readDelayedObjects() throws IOException, ClassNotFoundException {
        if (super.readObject().equals("Delayed:")) {
            int fieldCount = super.readInt();
            while (fieldCount > 0) {
                for (int i = 1; i <= fieldCount; ++i) {
                    DelayedField field = (DelayedField)ClassSource.readObject(this);
                    field.reassign();
                }
                fieldCount = super.readInt();
            }
        } else {
            throw new StreamCorruptedException("Stream did not contain expected delayed object section label.");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.readDelayedObjects();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new StreamCorruptedException("Exception occurred while reading delayed objects on close: " + String.valueOf(e));
        }
        finally {
            super.close();
        }
    }
}

