/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.ChannelTarget;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.UplinkProvider;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ChannelBinder
implements Binder {
    private final Variable _targetVariable;
    private final String _name;
    private final Variable _params;
    private final boolean _isOptional;

    public ChannelBinder(Variable targetVariable, String name, Variable params, boolean isOptional) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._targetVariable = targetVariable;
        this._name = name;
        this._params = params;
        this._isOptional = isOptional;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Object value = this._targetVariable.getValue();
        if (value instanceof ChannelTarget) {
            ChannelTarget channelTarget = (ChannelTarget)value;
            Collection<UplinkProvider> uplinkProviders = channelTarget.getUplinkProviders(this._name);
            return BindingBadness.clip(uplinkProviders.size());
        }
        return 10000;
    }

    @Override
    public void bind(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ChannelTarget channelTarget = (ChannelTarget)this._targetVariable.getValue();
        ArrayList<UplinkProvider> providers = new ArrayList<UplinkProvider>(channelTarget.getUplinkProviders(this._name));
        Collections.shuffle(providers);
        Iterator uplinkProviders = providers.iterator();
        if (this._isOptional && !uplinkProviders.hasNext()) {
            searcher.search();
            return;
        }
        while (uplinkProviders.hasNext() && !searcher.isCompleted()) {
            UplinkProvider uplinkProvider = (UplinkProvider)uplinkProviders.next();
            uplinkProvider.bindChannel(this._params, searcher);
        }
    }
}

