/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.INetInstantiator;
import de.renew.net.NetElementID;
import de.renew.net.NetInstantiator;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Net
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Net.class);
    private static final long serialVersionUID = 4424943946669800287L;
    private final Set<Place> _places = new HashSet<Place>();
    private final Set<Transition> _transitions = new HashSet<Transition>();
    private final Map<NetElementID, Place> _placesByID = new HashMap<NetElementID, Place>();
    private final Map<NetElementID, Transition> _transitionsByID = new HashMap<NetElementID, Transition>();
    private String _name = null;
    private boolean _earlyTokens = false;
    private int _netCount = 0;
    private INetInstantiator _instantiator = null;

    public Net() {
        this(null);
    }

    public Net(String name) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._name = name;
    }

    public Collection<Place> places() {
        return this._places;
    }

    public int placeCount() {
        return this._places.size();
    }

    public Collection<Transition> transitions() {
        return this._transitions;
    }

    public int transitionCount() {
        return this._transitions.size();
    }

    synchronized int makeNetNumber() {
        return ++this._netCount;
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String newName) {
        this._name = newName;
    }

    protected INetInstantiator createNetInstantiator() {
        return new NetInstantiator(this);
    }

    public INetInstantiator getInstantiator() {
        if (this._instantiator == null) {
            this._instantiator = this.createNetInstantiator();
        }
        return this._instantiator;
    }

    void add(Place place) {
        NetElementID id = place.getID();
        assert (!this._places.contains(place)) : "Tried to add existing place: " + String.valueOf(place);
        assert (!this._placesByID.containsKey(id)) : "Tried to add place with existing ID: " + String.valueOf(id) + ", old: " + String.valueOf(this._placesByID.get(id)) + ", new: " + String.valueOf(place);
        this._places.add(place);
        this._placesByID.put(id, place);
    }

    void add(Transition transition) {
        NetElementID id = transition.getID();
        assert (!this._transitions.contains(transition)) : "Tried to add existing transition: " + String.valueOf(transition);
        assert (!this._transitionsByID.containsKey(id)) : "Tried to add transition with existing ID: " + String.valueOf(id) + ", old: " + String.valueOf(this._transitionsByID.get(id)) + ", new: " + String.valueOf(transition);
        this._transitions.add(transition);
        this._transitionsByID.put(id, transition);
    }

    void remove(Place place) {
        this._places.remove(place);
        this._placesByID.remove(place.getID());
    }

    void remove(Transition transition) {
        this._transitions.remove(transition);
        this._transitionsByID.remove(transition.getID());
    }

    public boolean getEarlyTokens() {
        return this._earlyTokens;
    }

    public void setEarlyTokens(boolean earlyTokens) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._earlyTokens = earlyTokens;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rOut = null;
        if (out instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)out;
        }
        if (rOut != null) {
            rOut.beginDomain((Object)this);
        }
        out.defaultWriteObject();
        if (rOut != null) {
            rOut.endDomain((Object)this);
        }
    }

    public Place getPlaceWithID(NetElementID id) {
        return this._placesByID.get(id);
    }

    public Transition getTransitionWithID(NetElementID id) {
        return this._transitionsByID.get(id);
    }
}

