/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationLockExecutorProvider;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.loading.NetLoader;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.simulatorontology.loading.NetNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class NetLookup
implements INetLookup {
    private static final Logger LOGGER = Logger.getLogger(NetLookup.class);
    private static final Map<String, Net> NETS = new HashMap<String, Net>();
    private static NetLoader _netLoader;
    private final ISimulationLockExecutor _simulationLockExecutor;

    public NetLookup() {
        this(SimulationLockExecutorProvider.provider());
    }

    public NetLookup(ISimulationLockExecutor lockExecutor) {
        this._simulationLockExecutor = lockExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Net findForName(String name) throws NetNotFoundException {
        this._simulationLockExecutor.lock();
        Future<Net> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
            Net net = NETS.get(name);
            if (net != null) {
                return net;
            }
            if (_netLoader == null) {
                throw new NetNotFoundException(name);
            }
            net = NETS.get(name);
            if (net == null) {
                return _netLoader.loadNet(name);
            }
            return net;
        });
        try {
            Net net = future.get();
            return net;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof NetNotFoundException) {
                NetNotFoundException netNotFoundException = (NetNotFoundException)throwable;
                throw netNotFoundException;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            this._simulationLockExecutor.unlock();
        }
        return null;
    }

    @Override
    public void forgetAllNets() {
        this._simulationLockExecutor.runWithLock(NETS::clear);
    }

    @Override
    public Collection<Net> getAllKnownNets() {
        return new HashSet<Net>(NETS.values());
    }

    @Override
    public boolean isKnownNet(String name) {
        return NETS.containsKey(name);
    }

    @Override
    public void makeNetKnown(Net net) {
        Objects.requireNonNull(net);
        this._simulationLockExecutor.runWithLock(() -> NETS.put(net.getName(), net));
    }

    @Override
    public void makeNetsKnown(Collection<Net> nets) {
        this._simulationLockExecutor.runWithLock(() -> NETS.putAll(nets.stream().collect(Collectors.toMap(Net::getName, Function.identity()))));
    }

    @Override
    public void setNetLoader(NetLoader netLoader) {
        this._simulationLockExecutor.runWithLock(() -> {
            if (!NETS.isEmpty()) {
                throw new IllegalStateException("Cannot change net loader while nets are known.");
            }
            _netLoader = netLoader;
        });
    }

    @Override
    public NetLoader getNetLoader() {
        return _netLoader;
    }
}

