/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TestTokenBag;
import de.renew.net.TimeSet;
import de.renew.net.TokenBag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class TokenReservation {
    private final SimulatablePlaceInstance _instance;
    private int _reservations;
    private final TestTokenBag _testedTokens;
    private final TokenBag _removedTokenDelays;

    TokenReservation(SimulatablePlaceInstance instance) {
        this._instance = instance;
        this._reservations = 0;
        this._testedTokens = new TestTokenBag();
        this._removedTokenDelays = new TokenBag();
    }

    boolean isRemovable() {
        return this._reservations == 0;
    }

    private TimeSet getRemovedDelaySet(Object token, boolean isTested) {
        TimeSet delays = this._removedTokenDelays.getTimeSet(token);
        if (isTested && !this._instance.containsTestedToken(token)) {
            delays = delays.including(0.0);
        }
        return delays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double computeEarliestTime() {
        double result;
        this._instance._lock.lock();
        try {
            result = 0.0;
            HashSet<Object> tokens = new HashSet<Object>();
            tokens.addAll(this._testedTokens.uniqueElements());
            tokens.addAll(this._removedTokenDelays.uniqueElements());
            for (Object e : tokens) {
                boolean bl = this._testedTokens.getTestMultiplicity(e) > 0;
                TimeSet delays = this.getRemovedDelaySet(e, bl);
                double time = this._instance.computeEarliestTime(e, delays);
                if (!(time > result)) continue;
                result = time;
            }
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRemovableToken(Object token, double delay) {
        boolean result;
        this._instance._lock.lock();
        try {
            TimeSet delays = this.getRemovedDelaySet(token, this._testedTokens.getTestMultiplicity(token) > 0).including(delay);
            double time = this._instance.computeEarliestTime(token, delays);
            result = time < Double.POSITIVE_INFINITY;
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTestableToken(Object token) {
        boolean result;
        this._instance._lock.lock();
        try {
            TimeSet delays = this.getRemovedDelaySet(token, true);
            double time = this._instance.computeEarliestTime(token, delays);
            result = time < Double.POSITIVE_INFINITY;
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeToken(Object token, double delay) {
        boolean result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._instance._lock.lock();
        try {
            result = this.containsRemovableToken(token, delay);
            if (result) {
                this._removedTokenDelays.add(token, delay);
                ++this._reservations;
            }
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    public boolean testToken(Object token) {
        boolean result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._instance._lock.lock();
        try {
            result = this.containsTestableToken(token);
            if (result) {
                this._testedTokens.addTested(token, 0.0);
                ++this._reservations;
            }
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    public void unremoveToken(Object token, double delay) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._removedTokenDelays.removeOneOf(token, delay);
        --this._reservations;
    }

    public void untestToken(Object token) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._testedTokens.removeTested(token);
        --this._reservations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getRemovableTokens(Object pattern) {
        ArrayList<Object> result = new ArrayList<Object>();
        this._instance._lock.lock();
        try {
            for (Object token : this._instance.getDistinctTokens(pattern)) {
                if (!this.containsRemovableToken(token, Double.NEGATIVE_INFINITY)) continue;
                result.add(token);
            }
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getTestableTokens(Object pattern) {
        ArrayList<Object> result = new ArrayList<Object>();
        this._instance._lock.lock();
        try {
            for (Object token : this._instance.getDistinctTestableTokens(pattern)) {
                if (!this.containsTestableToken(token)) continue;
                result.add(token);
            }
        }
        finally {
            this._instance._lock.unlock();
        }
        return result;
    }
}

