/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.ArcOccurrence;
import java.util.Collection;
import java.util.Vector;

public class Arc
implements TransitionInscription {
    private final Place _place;
    private final Transition _transition;
    private final Type _arcType;
    private final Expression _tokenExpr;
    private final Expression _timeExpr;
    private boolean _trace;

    public Arc(Place place, Transition transition, Type arcType, Expression tokenExpr, Expression timeExpr) {
        if (arcType == null) {
            throw new RuntimeException("ArcType cannot be null.");
        }
        this._place = place;
        this._transition = transition;
        this._arcType = arcType;
        this._tokenExpr = tokenExpr;
        this._timeExpr = timeExpr;
        this._trace = true;
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public boolean isTestArc() {
        return this._arcType == Type.TEST || this._arcType == Type.FAST_TEST;
    }

    public boolean isUntimedArc() {
        return this.isTestArc() || this._arcType == Type.INHIBITOR;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(VariableMapper mapper, NetInstance netInstance, Searcher searcher) {
        Vector<Occurrence> coll = new Vector<Occurrence>();
        coll.add(new ArcOccurrence(this, mapper, netInstance));
        return coll;
    }

    public boolean isTypeOf(Type type) {
        return this._arcType == type;
    }

    public boolean getTrace() {
        return this._trace;
    }

    public Place getPlace() {
        return this._place;
    }

    public Transition getTransition() {
        return this._transition;
    }

    public Type getArcType() {
        return this._arcType;
    }

    public Expression getTokenExpression() {
        return this._tokenExpr;
    }

    public Expression getTimeExpression() {
        return this._timeExpr;
    }

    public static enum Type {
        IN,
        TEST,
        OUT,
        BOTH,
        FAST_BOTH,
        FAST_TEST,
        INHIBITOR,
        BOTH_OT;

    }
}

