/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.transition;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class AssignBinder
implements Binder {
    private final Variable _variable;
    private final boolean _checkBound;

    public AssignBinder(Variable variable, boolean checkBound) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._variable = variable;
        this._checkBound = checkBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindingBadness(Searcher searcher) {
        int result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this._variable)) {
            return 1;
        }
        this.lock();
        try {
            Collection<?> candidates = this.getCandidates(this._variable.getValue());
            result = BindingBadness.clip(candidates.size());
        }
        finally {
            this.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Searcher searcher) {
        ArrayList candidates;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this._variable) && !this._checkBound) {
            searcher.search();
            return;
        }
        TriggerableCollection triggerables = this.getTriggerables();
        if (triggerables != null) {
            searcher.insertTriggerable(triggerables);
        }
        this.lock();
        try {
            candidates = new ArrayList(this.getCandidates(this._variable.getValue()));
        }
        finally {
            this.unlock();
        }
        Collections.shuffle(candidates);
        Iterator values = candidates.iterator();
        while (values.hasNext() && !searcher.isCompleted()) {
            Object value = values.next();
            int checkpoint = searcher.getStateRecorder().checkpoint();
            try {
                Unify.unify(this._variable, value, searcher.getStateRecorder());
                searcher.search();
            }
            catch (Impossible impossible) {
                // empty catch block
            }
            searcher.getStateRecorder().restore(checkpoint);
        }
    }

    public abstract void lock();

    public abstract void unlock();

    public abstract Collection<?> getCandidates(Object var1);

    public abstract TriggerableCollection getTriggerables();
}

