/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.transition;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.net.inscription.AbstractOccurrence;
import de.renew.net.inscription.transition.ConditionalInscription;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

class ConditionalOccurrence
extends AbstractOccurrence
implements Occurrence,
Binder {
    private final ConditionalInscription _conditionalInscription;
    private final VariableMapper _mapper;
    private final NetInstance _netInstance;
    private Variable _conditionVariable;
    private Collection<Occurrence> _secondaryOccurrences;
    private boolean _wantToOccur;

    public ConditionalOccurrence(ConditionalInscription conditionalInscription, VariableMapper mapper, NetInstance netInstance, Transition transition) {
        super(netInstance.getInstance(transition));
        this._conditionalInscription = conditionalInscription;
        this._mapper = mapper;
        this._netInstance = netInstance;
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        IStateRecorder stateRecorder = searcher.getStateRecorder();
        ICalculationChecker calculationChecker = searcher.getCalculationChecker();
        this._conditionVariable = new Variable(this._conditionalInscription.getConditionExpression().startEvaluation(this._mapper, stateRecorder, calculationChecker), stateRecorder);
        Vector<Binder> coll = new Vector<Binder>();
        coll.add(this);
        return coll;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this._conditionVariable)) {
            return 1;
        }
        return 10000;
    }

    @Override
    public void bind(Searcher searcher) {
        Object obj = this._conditionVariable.getValue();
        if (!(obj instanceof Value)) {
            return;
        }
        if (!(obj instanceof Boolean)) {
            return;
        }
        ArrayList<Binder> binders = new ArrayList<Binder>();
        int checkpoint = searcher.getStateRecorder().checkpoint();
        try {
            boolean wantToOccur = (Boolean)((Value)obj).value;
            this._secondaryOccurrences = new ArrayList<Occurrence>();
            if (wantToOccur) {
                this._secondaryOccurrences.addAll(this._conditionalInscription.getInscription().makeOccurrences(this._mapper, this._netInstance, searcher));
                for (Occurrence occurrence : this._secondaryOccurrences) {
                    binders.addAll(occurrence.makeBinders(searcher));
                }
                searcher.addBinders(binders);
            }
            searcher.removeBinder(this);
            searcher.search();
            searcher.addBinder(this);
            if (wantToOccur) {
                searcher.removeBinders(binders);
                this._secondaryOccurrences = null;
            }
        }
        catch (Impossible impossible) {
            // empty catch block
        }
        searcher.getStateRecorder().restore(checkpoint);
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier copier) {
        if (!this._wantToOccur) {
            return Collections.emptyList();
        }
        return this._secondaryOccurrences.stream().flatMap(occurrence -> occurrence.makeExecutables(copier).stream()).toList();
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier variableMapperCopier) {
        return null;
    }

    Variable getConditionVariable() {
        return this._conditionVariable;
    }
}

