/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.net.Net;
import de.renew.net.loading.NetLoader;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;

class LoopbackNetLoader
implements NetLoader {
    private final ShadowLookup _lookup;
    private final ShadowNetSystem _shadowNetSystem;
    private final ShadowNetLoader _shadowNetLoader;

    LoopbackNetLoader(ShadowNetSystem shadowNetSystem, ShadowLookup lookup) {
        this._lookup = lookup;
        this._shadowNetSystem = shadowNetSystem;
        this._shadowNetLoader = shadowNetSystem.getNetLoader();
    }

    @Override
    public Net loadNet(String netName) throws NetNotFoundException {
        return this.appendNet(this._lookup, netName);
    }

    private Net appendNet(ShadowLookup lookup, String name) throws NetNotFoundException {
        if (this._shadowNetLoader != null) {
            Net net;
            ShadowNet shadowNet = this._shadowNetLoader.loadShadowNet(name, this._shadowNetSystem);
            if (!shadowNet.getName().equals(name)) {
                throw new NetNotFoundException(name + " (ShadowNetLoader provided " + shadowNet.getName() + " instead)");
            }
            try {
                net = ShadowNetSystemCompiler.getInstance().createShadowNetCompiler(lookup, shadowNet).createNet(shadowNet.getName());
            }
            catch (SyntaxException e) {
                throw new NetNotFoundException((Throwable)e);
            }
            lookup.setNet(shadowNet.getName(), net);
            return net;
        }
        throw new NetNotFoundException(name);
    }
}

