/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ccpn.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import de.renew.ccpn.engine.simulator.CCPNSimulation;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import org.apache.log4j.Logger;

public class CurryReachabilityGraphCommand
extends Command {
    private static final Logger LOGGER = Logger.getLogger(CurryReachabilityGraphCommand.class);
    public static final String CMD_NAME = "Curry Reachability Graph";

    public CurryReachabilityGraphCommand() {
        super(CMD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (!"Curry Net Compiler".equals(fp.getCompiler())) {
            SimulationManager.terminateSimulation();
            fp.setCompiler("Curry Net Compiler");
        }
        CCPNSimulation sim = (CCPNSimulation)ModeReplacement.getInstance().getSimulation();
        if (SimulationManager.isSimulationActive()) {
            sim.requestReachGraph();
        } else {
            try {
                String errorStr = CurryReachabilityGraphCommand.class.getSimpleName() + ": Could not start CCPN process for Curry reachability graph generation";
                DrawApplication gui = DrawPlugin.getGui();
                if (gui != null) {
                    Drawing drawing = gui.drawing();
                    if (drawing instanceof CPNDrawing) {
                        try {
                            sim.minimalInit(gui.drawing().getName());
                            sim.requestReachGraph();
                        }
                        catch (NetNotFoundException | SyntaxException | NoSimulationException e) {
                            LOGGER.error((Object)(errorStr + ": " + e.getMessage()), e);
                        }
                    } else if (drawing instanceof NullDrawing) {
                        LOGGER.error((Object)(errorStr + ": no drawing selected"));
                    } else {
                        LOGGER.error((Object)(errorStr + " of drawing of the class: " + String.valueOf(drawing.getClass())));
                    }
                } else {
                    LOGGER.error((Object)(errorStr + ": no active simulation and no GUI present"));
                }
            }
            finally {
                SimulationManager.terminateSimulation();
            }
        }
    }
}

