/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ccpn.engine.simulator;

import CH.ifa.draw.DrawPlugin;
import de.renew.ccpn.CCPNPlugin;
import de.renew.ccpn.engine.simulator.XMLOmitDeclStreamWriter;
import de.renew.ccpn.momoc.elements.CurryNode;
import de.renew.ccpn.net.CurryPlaceInstance;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.pnml.creator.PNMLCreator;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.GraphDrawing;
import de.renew.unify.Impossible;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CCPNProcess {
    public static final Logger LOGGER = Logger.getLogger(CCPNProcess.class);
    private final Process _process;
    private final List<Place> _places;
    private final NetInstance _simNetInstance;
    boolean _continuousUpdate = false;
    boolean _stopped = false;
    final XMLStreamWriter _writer;

    public static CCPNProcess startProcess(NetInstance netInstance, CPNDrawing drawing) {
        Document document;
        CCPNProcess retProcess;
        List placeFigs;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": starting process..."));
        }
        PNMLCreator creator = new PNMLCreator("http://www.pnml.org/version-2009/grammar/ptnet", true);
        try {
            placeFigs = creator.setDrawings(drawing);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Place> places = new ArrayList<Place>(placeFigs.size());
        for (PlaceFigure p : placeFigs) {
            places.add(netInstance.getNet().getPlaceWithID(new NetElementID(p.getID())));
        }
        ProcessBuilder pb = new ProcessBuilder(CCPNPlugin.getCCPNLocation());
        try {
            retProcess = new CCPNProcess(pb.start(), places, netInstance);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element loadElem = document.createElement("load");
        File filename = drawing.getFilename();
        if (filename != null) {
            try {
                loadElem.setAttribute("baseFile", filename.getCanonicalPath());
            }
            catch (IOException | DOMException e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        loadElem.appendChild(document.adoptNode(creator.getDocumentElement()));
        retProcess.sendElement(loadElem);
        retProcess.execute();
        return retProcess;
    }

    private void execute() {
        SimulationThreadPool.getCurrent().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new BufferedInputStream(CCPNProcess.this._process.getInputStream()), (DefaultHandler)new SAXHandler());
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public CCPNProcess(Process process, List<Place> places, NetInstance netInstance) {
        this._process = process;
        this._places = places;
        this._simNetInstance = netInstance;
        try {
            this._writer = XMLOutputFactory.newFactory().createXMLStreamWriter(new BufferedOutputStream(process.getOutputStream()), "UTF-8");
            this._writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    public void terminate() {
        this._stopped = true;
        this._continuousUpdate = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": closing XML stream to process."));
        }
        try {
            this._writer.writeEndDocument();
            this._writer.flush();
            this._writer.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        try {
            this._process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void run() {
        this.sendElement("run");
        this.getMarking();
    }

    void stop() {
        this.sendElement("stop");
        this.getMarking();
    }

    void step() {
        this.sendElement("step");
        this.getMarking();
    }

    void reachGraph() {
        this.sendElement("reachGraph");
    }

    private void getMarking() {
        this.sendElement("getMarking");
    }

    private void sendElement(Element elem) {
        if (this._stopped) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": sending " + elem.getTagName() + " DOM element"));
        }
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(elem), new StAXResult(new XMLOmitDeclStreamWriter(this._writer)));
            this._writer.writeEndDocument();
            this._writer.flush();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            CCPNProcess.handleXMLStreamException(e);
        }
    }

    private void sendElement(String tag) {
        if (this._stopped) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": sending " + tag + " empty element"));
        }
        try {
            this._writer.writeEmptyElement(tag);
            this._writer.writeEndDocument();
            this._writer.flush();
        }
        catch (XMLStreamException e) {
            CCPNProcess.handleXMLStreamException(e);
        }
    }

    private static void handleXMLStreamException(XMLStreamException e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException && "Stream closed".equals(cause.getMessage())) {
            return;
        }
        throw new RuntimeException(e);
    }

    private class SAXHandler
    extends DefaultHandler {
        private static final String CCPN_OUTPUT = "ccpnOutput";
        private static final String NET_MARKING = "netMarking";
        private static final String NET_MARKING_STOPPED = "stopped";
        private static final String NET_MARKING_STOPPED_TRUE = "true";
        private static final String PLACE_STATE = "placeState";
        private static final String TOKEN = "token";
        private static final String TOKEN_COUNT = "count";
        private static final String ERROR = "error";
        private static final String LOAD_ERROR = "loadError";
        private static final String LOAD_WARNING = "loadWarning";
        private static final String REACH_GRAPH = "reachGraph";
        private static final String INITIAL_STATE = "initialState";
        private static final String ID = "id";
        private static final String REF = "ref";
        private static final String NAME = "name";
        private static final String TARGET = "target";
        private static final String NODE = "node";
        private static final String EDGE = "edge";
        private StringBuffer _errorStringBuffer = null;
        private StringBuffer _loadErrorStringBuffer = null;
        private StringBuffer _loadWarningStringBuffer = null;
        private Stack<StringBuffer> _debugOutput;
        private Iterator<Place> _placeIterator;
        private CurryPlaceInstance _currentPlace;
        private StringBuffer _currentTokenStr = null;
        private int _currentTokenCount;
        private CurryNode _startNode = null;
        private List<String> _initialStates = null;
        private Map<String, NodeEntry> _nodes = null;
        private NodeEntry _currentNode = null;
        private EdgeEntry _currentEdge;

        private SAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": CCPN " + (CCPNProcess.this._stopped ? "(stopped) " : "") + "returned: <" + qName + ">"));
            }
            if (TOKEN.equalsIgnoreCase(qName)) {
                this._currentTokenStr = new StringBuffer();
                this._currentTokenCount = Integer.parseUnsignedInt(attributes.getValue("", TOKEN_COUNT));
            } else if (PLACE_STATE.equalsIgnoreCase(qName)) {
                NetInstance netInstance = this._currentNode == null ? CCPNProcess.this._simNetInstance : this._currentNode._node.getRootNetInstance();
                this._currentPlace = (CurryPlaceInstance)netInstance.getInstance(this._placeIterator.next());
                this._currentPlace.resetMarking();
            } else if (NET_MARKING.equalsIgnoreCase(qName)) {
                this._placeIterator = CCPNProcess.this._places.iterator();
                if (NET_MARKING_STOPPED_TRUE.equalsIgnoreCase(attributes.getValue("", NET_MARKING_STOPPED))) {
                    CCPNProcess.this._continuousUpdate = false;
                }
            } else if (ERROR.equalsIgnoreCase(qName)) {
                this._errorStringBuffer = new StringBuffer();
            } else if (LOAD_ERROR.equalsIgnoreCase(qName)) {
                this._loadErrorStringBuffer = new StringBuffer();
            } else if (LOAD_WARNING.equalsIgnoreCase(qName)) {
                this._loadWarningStringBuffer = new StringBuffer();
            } else if (EDGE.equalsIgnoreCase(qName)) {
                this._currentEdge = new EdgeEntry(attributes.getValue("", NAME), attributes.getValue("", TARGET));
            } else if (NODE.equalsIgnoreCase(qName)) {
                try {
                    this._currentNode = new NodeEntry(new CurryNode(CCPNProcess.this._simNetInstance.getNet().getInstantiator().makeInstance()));
                }
                catch (Impossible e) {
                    LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                }
                this._nodes.put(attributes.getValue("", ID), this._currentNode);
            } else if (INITIAL_STATE.equalsIgnoreCase(qName)) {
                this._initialStates.add(attributes.getValue("", REF));
            } else if (REACH_GRAPH.equalsIgnoreCase(qName)) {
                try {
                    this._startNode = new CurryNode(CCPNProcess.this._simNetInstance.getNet().getInstantiator().makeInstance());
                }
                catch (Impossible e) {
                    LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                }
                this._nodes = new HashMap<String, NodeEntry>();
                this._initialStates = new ArrayList<String>();
            } else if (LOGGER.isDebugEnabled() && !CCPN_OUTPUT.equalsIgnoreCase(qName)) {
                if (this._debugOutput == null) {
                    this._debugOutput = new Stack();
                }
                this._debugOutput.push(new StringBuffer());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (TOKEN.equalsIgnoreCase(qName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": " + this._currentTokenCount + " token" + (this._currentTokenCount > 1 ? "s" : "") + " in " + String.valueOf(this._currentPlace) + " : " + String.valueOf(this._currentTokenStr)));
                }
                this._currentPlace.addToken(this._currentTokenStr.toString(), this._currentTokenCount);
                this._currentTokenStr = null;
            } else if (PLACE_STATE.equalsIgnoreCase(qName)) {
                this._currentPlace.notifyListeners();
                this._currentPlace = null;
            } else if (NET_MARKING.equalsIgnoreCase(qName)) {
                this._placeIterator = null;
                if (CCPNProcess.this._continuousUpdate) {
                    CCPNProcess.this.getMarking();
                }
            } else if (ERROR.equalsIgnoreCase(qName)) {
                if (this._errorStringBuffer.length() == 0) {
                    LOGGER.error((Object)"CCPN returned error.");
                } else {
                    LOGGER.error((Object)("CCPN: " + this._errorStringBuffer.toString()));
                }
                this._errorStringBuffer = null;
            } else if (LOAD_ERROR.equalsIgnoreCase(qName)) {
                LOGGER.error((Object)("CCPN errors while loading:\n" + this._loadErrorStringBuffer.toString()));
                this._loadErrorStringBuffer = null;
            } else if (LOAD_WARNING.equalsIgnoreCase(qName)) {
                LOGGER.warn((Object)("CCPN warnings while loading\n:" + this._loadWarningStringBuffer.toString()));
                this._loadWarningStringBuffer = null;
            } else if (EDGE.equalsIgnoreCase(qName)) {
                this._currentNode._edges.add(this._currentEdge);
                this._currentEdge = null;
            } else if (NODE.equalsIgnoreCase(qName)) {
                this._currentNode = null;
            } else if (REACH_GRAPH.equalsIgnoreCase(qName)) {
                ArrayList<CurryNode> gNodes = new ArrayList<CurryNode>(this._nodes.size() + 1);
                for (String is : this._initialStates) {
                    this._startNode.addEdge(this._nodes.get((Object)is)._node);
                }
                gNodes.add(this._startNode);
                for (NodeEntry ni : this._nodes.values()) {
                    for (EdgeEntry e : ni._edges) {
                        ni._node.addEdge(e._name, e._description, this._nodes.get((Object)e._target)._node);
                    }
                    gNodes.add(ni._node);
                }
                DrawPlugin.getGui().openDrawing((Drawing)new GraphDrawing(() -> false, gNodes, (Node)this._startNode, 0, true));
                this._startNode = null;
                this._nodes = null;
                this._initialStates = null;
            } else if (this._debugOutput != null && !this._debugOutput.empty()) {
                StringBuffer buf = this._debugOutput.pop();
                LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": ignoring unknown element " + qName + (String)(buf.length() == 0 ? "" : " with contents: " + buf.toString())));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this._currentTokenStr != null) {
                this._currentTokenStr.append(ch, start, length);
            } else if (this._errorStringBuffer != null) {
                this._errorStringBuffer.append(ch, start, length);
            } else if (this._loadErrorStringBuffer != null) {
                this._loadErrorStringBuffer.append(ch, start, length);
            } else if (this._loadWarningStringBuffer != null) {
                this._loadWarningStringBuffer.append(ch, start, length);
            } else if (this._currentEdge != null) {
                String str = String.valueOf(ch, start, length);
                this._currentEdge._description = this._currentEdge._description + str;
            } else if (this._debugOutput != null && !this._debugOutput.empty()) {
                this._debugOutput.peek().append(ch, start, length);
            }
        }

        @Override
        public void endDocument() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(CCPNProcess.class.getSimpleName() + ": CCPN output ended."));
            }
        }

        final class NodeEntry {
            public final CurryNode _node;
            public final List<EdgeEntry> _edges = new ArrayList<EdgeEntry>();

            public NodeEntry(CurryNode node) {
                this._node = node;
            }
        }

        final class EdgeEntry {
            public final String _name;
            public String _description = "";
            public final String _target;

            public EdgeEntry(String name, String target) {
                this._name = name;
                this._target = target;
            }
        }
    }
}

