/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ScriptCommand
implements CLCommand {
    public static final Logger LOGGER = Logger.getLogger(ScriptCommand.class);
    String[] _lastScript;

    @Override
    public void execute(String[] args, PrintStream response) {
        if (args.length > 1) {
            response.println("ScriptCommand: more than one parameter given: using only " + args[0]);
        }
        Collection<String> lines = this.readFile(args[0], response);
        Collection<CommandArgumentTuple> commands = this.createCommands(lines, response);
        Iterator<CommandArgumentTuple> commandIterator = commands.iterator();
        while (commandIterator.hasNext()) {
            try {
                CommandArgumentTuple command = commandIterator.next();
                command.execute(response);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("PluginManager.PromptThread: an exeption occurred: " + String.valueOf(e)));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getDescription() {
        return "reads an input file and interprets every line as a PluginManager command";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> readFile(String filename, PrintStream response) {
        response.println("ScriptCommand: Try to load file " + filename);
        Vector<String> lines = new Vector<String>();
        File f = new File(filename);
        String line = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                lines.add(line);
            }
        }
        catch (FileNotFoundException e) {
            response.println("ScriptCommand: file " + filename + " not found.");
        }
        catch (IOException e) {
            LOGGER.error((Object)("ScriptCommand: exception when reading " + filename + ": "), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lines;
    }

    private Collection<CommandArgumentTuple> createCommands(Collection<String> toConvertCollection, PrintStream response) {
        Map<String, CLCommand> commands = PluginManager.getInstance().getCLCommands();
        Vector<CommandArgumentTuple> result = new Vector<CommandArgumentTuple>();
        Iterator<String> toConvertIterator = toConvertCollection.iterator();
        boolean blockCommentActive = false;
        while (toConvertIterator.hasNext()) {
            String toConvert = toConvertIterator.next();
            if (!blockCommentActive && toConvert.trim().startsWith("/*")) {
                LOGGER.debug((Object)"Block comment started");
                blockCommentActive = true;
            }
            if (blockCommentActive && (toConvert.trim().endsWith("*/") || toConvert.trim().equals("*/"))) {
                LOGGER.debug((Object)"Block comment ended");
                blockCommentActive = false;
                continue;
            }
            LOGGER.debug((Object)("CONVERT TO COMMAND " + toConvert));
            List<String> split = this.splitString(toConvert);
            if (toConvert.trim().length() == 0 || blockCommentActive || split.size() == 0 || split.get(0).trim().startsWith("#")) continue;
            CLCommand c = commands.get(split.get(0));
            if (c == null) {
                response.println("ScriptCommand: unknown command: " + split.get(0));
                continue;
            }
            String[] nc = new String[split.size() - 1];
            for (int i = 0; i < nc.length; ++i) {
                nc[i] = split.get(i + 1);
            }
            CommandArgumentTuple cat = new CommandArgumentTuple(c, nc);
            result.add(cat);
        }
        return result;
    }

    protected List<String> splitString(String s) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(s);
        while (m.find()) {
            list.add(m.group(1).replace("\"", ""));
        }
        return list;
    }

    @Override
    public String getArguments() {
        return "fileNames";
    }

    private class CommandArgumentTuple {
        private CLCommand _command;
        private String[] _arguments;

        public CommandArgumentTuple(CLCommand command, String[] args) {
            this._command = command;
            this._arguments = args;
        }

        public void execute(PrintStream response) {
            this._command.execute(this._arguments, response);
        }
    }
}

