/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.api.ISimulationStateLoader;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationLockExecutorProvider;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.IDRegistry;
import de.renew.net.NetInstance;
import de.renew.net.NetLookup;
import de.renew.net.serialisation.NetDeserializer;
import de.renew.plugin.PropertyHelper;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.simulation.SimulationRunningException;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

class SimulationStateLoader
implements ISimulationStateLoader {
    private static final Logger LOGGER = Logger.getLogger(SimulationStateLoader.class);
    private final ISimulationManager _simulationManager;
    private static final ISimulationLockExecutor LOCK_EXECUTOR = SimulationLockExecutorProvider.provider();

    SimulationStateLoader(ISimulationManager simulationManager) {
        this._simulationManager = simulationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetInstance[] loadState(ObjectInput input, Properties props) throws IOException, ClassNotFoundException, SimulationRunningException {
        NetLookup netLookup = new NetLookup(LOCK_EXECUTOR);
        LOCK_EXECUTOR.lock();
        try {
            Future<NetInstance[]> future = SimulationThreadPool.getNew().submitAndWait(() -> {
                ArrayList<NetInstance> explicitInstances;
                try {
                    LOGGER.debug((Object)"Loading simulation state...");
                    this._simulationManager.setupSimulation(props);
                    String streamLabel = (String)input.readObject();
                    if (!streamLabel.equals("RenewState")) {
                        throw new StreamCorruptedException("Stream does not seem to contain renew state data.");
                    }
                    int streamVersion = input.readInt();
                    if (streamVersion != 9) {
                        throw new StreamCorruptedException("State data is of different version (" + streamVersion + ") than the current version (9).");
                    }
                    int simulatorMultiplicity = PropertyHelper.getIntProperty((Properties)this._simulationManager.getSimulationProperties(), (String)"de.renew.simulatorMultiplicity", (int)1);
                    int streamSimulatorMultiplicity = input.readInt();
                    if (streamSimulatorMultiplicity != simulatorMultiplicity) {
                        LOGGER.warn((Object)("Simulation state was saved using a different simulator multiplicity (" + streamSimulatorMultiplicity + ") than currently selected (" + simulatorMultiplicity + ")."));
                    }
                    int count = input.readInt();
                    explicitInstances = new ArrayList<NetInstance>(count);
                    try {
                        for (int i = 0; i < count; ++i) {
                            explicitInstances.add((NetInstance)ClassSource.readObject((ObjectInput)input));
                        }
                    }
                    catch (ClassCastException e) {
                        LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                        throw new StreamCorruptedException("Object other than NetInstance found when looking for net instances: " + e.getMessage());
                    }
                    if (input instanceof RenewObjectInputStream) {
                        ((RenewObjectInputStream)input).readDelayedObjects();
                    }
                    new NetDeserializer(netLookup).loadNets(input);
                    SearchQueue.loadQueue(input);
                    IDRegistry.load(input);
                }
                catch (IOException e) {
                    this._simulationManager.terminateSimulation();
                    throw e;
                }
                catch (ClassNotFoundException | StackOverflowError e) {
                    this._simulationManager.terminateSimulation();
                    throw e;
                }
                return explicitInstances.toArray(new NetInstance[0]);
            });
            NetInstance[] netInstanceArray = future.get();
            return netInstanceArray;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof SimulationRunningException) {
                throw new SimulationRunningException((Throwable)e);
            }
            if (t instanceof IOException) {
                IOException exc = (IOException)t;
                throw exc;
            }
            if (t instanceof ClassNotFoundException) {
                throw new ClassNotFoundException(t.getMessage(), e);
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            LOCK_EXECUTOR.unlock();
        }
        return null;
    }
}

