/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.SimulationControlCommand;
import de.renew.application.SimulationManagerProvider;
import de.renew.application.SimulationStateRestorerImpl;
import de.renew.application.StartSimulationCommand;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.thread.SimulationLockExecutorProvider;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.IDRegistry;
import de.renew.net.INetLookup;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetLookup;
import de.renew.net.serialisation.NetSerializer;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.command.CLCommand;
import de.renew.simulator.api.ISimulationLockExecutor;
import de.renew.simulator.api.ISimulationManager;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import de.renew.simulatorontology.simulation.Simulator;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.SingletonException;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SimulatorPlugin
extends PluginAdapter {
    static final int STATE_STREAM_VERSION = 9;
    static final String STATE_STREAM_LABEL = "RenewState";
    private static final String MAIN_PACKAGE_NAME = "de.renew.simulator";
    private static final String SIMULATION_CONTROL_COMMAND = "simulator";
    private static final String SIMULATION_START_COMMAND = "startsimulator";
    private static final Logger LOGGER = Logger.getLogger(SimulatorPlugin.class);
    private static final Object SINGLETON_LOCK = new Object();
    private static final ISimulationLockExecutor LOCK_EXECUTOR = SimulationLockExecutorProvider.provider();
    private static SimulatorPlugin _singleton = null;
    private final ISimulationManager _simulationManager;
    private final INetLookup _netLookup = new NetLookup(LOCK_EXECUTOR);
    private boolean _previousClassReinit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimulatorPlugin(PluginProperties props) {
        super(props);
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (_singleton != null) {
                throw new SingletonException("At most one instance of SimulatorPlugin is allowed.");
            }
            _singleton = this;
        }
        this._simulationManager = SimulationManagerProvider.provider();
    }

    private void checkSingleton() {
        if (_singleton != this) {
            throw new SingletonException();
        }
    }

    public void init() {
        this.checkSingleton();
        PluginManager.getInstance().addCLCommand(SIMULATION_START_COMMAND, (CLCommand)new StartSimulationCommand(this._simulationManager, this, LOCK_EXECUTOR, new SimulationStateRestorerImpl(LOCK_EXECUTOR, this._simulationManager)));
        PluginManager.getInstance().addCLCommand(SIMULATION_CONTROL_COMMAND, (CLCommand)new SimulationControlCommand(this._simulationManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(ObjectOutput output, NetInstance[] instances) throws IOException {
        this.checkSingleton();
        LOCK_EXECUTOR.lock();
        try {
            Future<Object> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                if (!this._simulationManager.isSimulationSetup()) {
                    throw new NoSimulationException();
                }
                this._simulationManager.getCurrentSimulator().stopRun();
                RenewObjectOutputStream rOut = null;
                if (output instanceof RenewObjectOutputStream) {
                    rOut = (RenewObjectOutputStream)output;
                }
                if (rOut != null) {
                    rOut.beginDomain(SimulatorPlugin.class);
                }
                output.writeObject(STATE_STREAM_LABEL);
                output.writeInt(9);
                output.writeInt(PropertyHelper.getIntProperty((Properties)this._simulationManager.getSimulationProperties(), (String)"de.renew.simulatorMultiplicity"));
                output.writeInt(instances.length);
                for (NetInstance instance : instances) {
                    output.writeObject(instance);
                }
                if (rOut != null) {
                    rOut.writeDelayedObjects();
                }
                new NetSerializer(LOCK_EXECUTOR, new NetLookup()).saveAllKnownNets(output);
                SearchQueue.saveQueue(output);
                IDRegistry.save(output);
                if (rOut != null) {
                    rOut.endDomain(SimulatorPlugin.class);
                }
                return null;
            });
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                IOException exc = (IOException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            LOCK_EXECUTOR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetInstance createNetInstance(String net) throws NetNotFoundException, NoSimulationException {
        this.checkSingleton();
        LOCK_EXECUTOR.lock();
        try {
            Future<NetInstance> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                NetInstance netInstance = null;
                if (!this._simulationManager.isSimulationSetup()) {
                    throw new NoSimulationException();
                }
                Simulator currentSimulator = this._simulationManager.getCurrentSimulator();
                if (net != null) {
                    Net netTemplate = this._netLookup.findForName(net);
                    netInstance = netTemplate.getInstantiator().buildInstance(currentSimulator.nextStepIdentifier());
                    currentSimulator.refresh();
                }
                return netInstance;
            });
            NetInstance netInstance = future.get();
            return netInstance;
        }
        catch (InterruptedException e) {
            LOGGER.info((Object)"Creation of NetInstances was aborted");
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NetNotFoundException) {
                NetNotFoundException exc = (NetNotFoundException)t;
                throw exc;
            }
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            LOCK_EXECUTOR.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cleanup() {
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            this.checkSingleton();
            this._simulationManager.terminateSimulation();
            this._simulationManager.cleanup();
            _singleton = null;
        }
        PluginManager.getInstance().removeCLCommand(SIMULATION_START_COMMAND);
        PluginManager.getInstance().removeCLCommand(SIMULATION_CONTROL_COMMAND);
        return true;
    }

    public boolean canShutDown() {
        this.checkSingleton();
        return true;
    }

    public <T> T submitAndWait(Callable<T> task) throws InterruptedException {
        this.checkSingleton();
        LOCK_EXECUTOR.lock();
        try {
            if (!this._simulationManager.isSimulationSetup()) {
                throw new NoSimulationException();
            }
            Future<T> futureObj = SimulationThreadPool.getCurrent().submitAndWait(task);
            T t = futureObj.get();
            return t;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof NoSimulationException) {
                NoSimulationException exc = (NoSimulationException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)("Simulation thread threw an exception: " + String.valueOf(t)), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            LOCK_EXECUTOR.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void possiblySetupClassSource(Properties props) throws IllegalStateException {
        this.checkSingleton();
        LOCK_EXECUTOR.lock();
        try {
            Future<Object> result = SimulationThreadPool.getCurrent().submitAndWait(() -> {
                if (this._simulationManager.isSimulationActive()) {
                    throw new IllegalStateException("Reconfiguration of class source is not allowed while a simulation is running.");
                }
                boolean classReinit = PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.classReinit");
                if (classReinit) {
                    if (!this._previousClassReinit) {
                        LOGGER.info((Object)"Using classReinit mode.");
                    } else {
                        LOGGER.debug((Object)"SimulatorPlugin: Re-initialising class loader.");
                    }
                    ClassLoader classLoader = PluginManager.getInstance().getNewBottomClassLoader();
                    ClassSource.setClassLoader((ClassLoader)classLoader);
                } else if (this._previousClassReinit) {
                    LOGGER.debug((Object)"classReinit mode disabled.");
                    ClassSource.setClassLoader(null);
                }
                this._previousClassReinit = classReinit;
                return null;
            });
            result.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalStateException) {
                IllegalStateException exc = (IllegalStateException)t;
                throw exc;
            }
            if (t instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)t;
                throw exc;
            }
            if (t instanceof Error) {
                Error exc = (Error)t;
                throw exc;
            }
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        finally {
            LOCK_EXECUTOR.unlock();
        }
    }

    public static SimulatorPlugin getCurrent() {
        for (IPlugin plugin : PluginManager.getInstance().getPluginsProviding(MAIN_PACKAGE_NAME)) {
            if (!(plugin instanceof SimulatorPlugin)) continue;
            return (SimulatorPlugin)plugin;
        }
        return _singleton;
    }
}

