/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.DSQEnumeration;
import de.renew.engine.searchqueue.DSQListNode;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.thread.SimulationThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

class DeterministicSearchQueue
implements SearchQueueData {
    private final double _time;
    private DSQListNode _list;
    private final Hashtable<Searchable, DSQListNode> _lookup;

    DeterministicSearchQueue(double time) {
        this._time = time;
        this._list = null;
        this._lookup = new Hashtable();
    }

    @Override
    public double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return this._time;
    }

    @Override
    public void include(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode node = this._lookup.get(searchable);
        if (node != null) {
            return;
        }
        node = new DSQListNode(searchable);
        this._lookup.put(searchable, node);
        if (this._list == null) {
            this._list = node;
        } else {
            node.setPrevious(this._list.getPrevious());
            node.setNext(this._list);
            this._list.getPrevious().setNext(node);
            this._list.setPrevious(node);
        }
    }

    private void discard(DSQListNode node) {
        this._lookup.remove(node.getElement());
        if (node == node.getNext()) {
            this._list = null;
        } else {
            node.getNext().setPrevious(node.getPrevious());
            node.getPrevious().setNext(node.getNext());
            if (this._list == node) {
                this._list = node.getNext();
            }
        }
    }

    @Override
    public void exclude(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        DSQListNode node = this._lookup.get(searchable);
        if (node != null) {
            this.discard(node);
        }
    }

    @Override
    public Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this._list == null) {
            return null;
        }
        Searchable result = this._list.getElement();
        this.discard(this._list);
        return result;
    }

    @Override
    public Enumeration<Searchable> elements() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new DSQEnumeration(this._list);
    }

    @Override
    public int size() {
        return this._lookup.size();
    }
}

