/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.Arc;
import de.renew.net.inscription.arc.FlexibleArcOccurrence;
import java.util.Collection;
import java.util.Vector;

public class FlexibleArc
implements TransitionInscription {
    public static final Arc.Type IN = Arc.Type.IN;
    public static final Arc.Type OUT = Arc.Type.OUT;
    public static final Arc.Type FAST_BOTH = Arc.Type.FAST_BOTH;
    private final Place _place;
    private final Transition _transition;
    private final Arc.Type _arcType;
    private final Expression _expression;
    private final Function _forwardFunction;
    private final Function _backwardFunction;
    private boolean _trace;

    public FlexibleArc(Place place, Transition transition, Arc.Type arcType, Expression expression, Function forwardFunction, Function backwardFunction) {
        this._place = place;
        this._transition = transition;
        this._arcType = arcType;
        this._expression = expression;
        this._forwardFunction = forwardFunction;
        this._backwardFunction = backwardFunction;
        this._trace = true;
    }

    boolean isOutputArc() {
        return this._arcType == Arc.Type.OUT;
    }

    public void setTrace(boolean trace) {
        this._trace = trace;
    }

    public boolean getTrace() {
        return this._trace;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(VariableMapper mapper, NetInstance netInstance, Searcher searcher) {
        Vector<Occurrence> coll = new Vector<Occurrence>();
        coll.add(new FlexibleArcOccurrence(this, mapper, netInstance));
        return coll;
    }

    Place getPlace() {
        return this._place;
    }

    Transition getTransition() {
        return this._transition;
    }

    Arc.Type getArcType() {
        return this._arcType;
    }

    Expression getExpression() {
        return this._expression;
    }

    Function getForwardFunction() {
        return this._forwardFunction;
    }

    Function getBackwardFunction() {
        return this._backwardFunction;
    }

    boolean isTrace() {
        return this._trace;
    }
}

