/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Searcher;
import de.renew.net.TokenReserver;
import de.renew.net.inscription.arc.FlexibleArcOccurrence;
import de.renew.unify.Impossible;
import de.renew.unify.List;
import de.renew.unify.Unify;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

class FlexibleArcBinder
implements Binder {
    public static final Logger LOGGER = Logger.getLogger(FlexibleArcBinder.class);
    private final FlexibleArcOccurrence _occurrence;

    FlexibleArcBinder(FlexibleArcOccurrence occurrence) {
        this._occurrence = occurrence;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this._occurrence.getTokenVar())) {
            return 1;
        }
        return 10000;
    }

    private void rememberSingleToken(Object token) {
        this._occurrence.getInTokens().addElement(Unify.copyBoundValue(token));
    }

    private Object applyConversionFunction(Object token) throws Impossible {
        if (this._occurrence.getArc().getForwardFunction() == null) {
            return token;
        }
        Object convertedToken = this._occurrence.getArc().getForwardFunction().function(token);
        if (this._occurrence.getArc().getBackwardFunction() != null) {
            Object restoredToken = this._occurrence.getArc().getBackwardFunction().function(convertedToken);
            Unify.unify(token, restoredToken, null);
        }
        return convertedToken;
    }

    @Override
    public void bind(Searcher searcher) {
        if (!Unify.isBound(this._occurrence.getTokenVar())) {
            throw new RuntimeException("Flexible arc binder was invoked for an incomplete value.");
        }
        Object tokens = this._occurrence.getTokenVar().getValue();
        this._occurrence.setInTokens(new Vector<Object>());
        if (tokens != null) {
            if (tokens.getClass().isArray()) {
                Class<?> elementType = tokens.getClass().getComponentType();
                int n = Array.getLength(tokens);
                for (int i = 0; i < n; ++i) {
                    Object token = null;
                    try {
                        token = Array.get(tokens, i);
                        if (elementType.isPrimitive()) {
                            token = new Value(token);
                        }
                        token = this.applyConversionFunction(token);
                        this.rememberSingleToken(token);
                        continue;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            } else if (tokens instanceof List) {
                List current = (List)tokens;
                while (!current.isNull()) {
                    this.rememberSingleToken(current.head());
                    if (current.tail() instanceof List) {
                        current = (List)current.tail();
                        continue;
                    }
                    break;
                }
            } else if (tokens instanceof Collection) {
                Collection coll = (Collection)tokens;
                for (Object o : coll) {
                    this.rememberSingleToken(o);
                }
            }
        }
        if (!this._occurrence.getArc().isOutputArc() && !this._occurrence.getInTokens().isEmpty()) {
            searcher.insertTriggerable(this._occurrence.getPlaceInstance().triggerables());
        }
        boolean success = true;
        int maxOk = 0;
        TokenReserver tokenReserver = TokenReserver.getInstance(searcher);
        while (success && maxOk < this._occurrence.getInTokens().size()) {
            try {
                success = tokenReserver.removeToken(this._occurrence.getPlaceInstance(), this._occurrence.getInTokens().elementAt(maxOk), 0.0);
                if (!success) continue;
                ++maxOk;
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                success = false;
            }
        }
        if (success) {
            searcher.search();
        }
        while (maxOk > 0) {
            tokenReserver.unremoveToken(this._occurrence.getPlaceInstance(), this._occurrence.getInTokens().elementAt(--maxOk), 0.0);
        }
        this._occurrence.setInTokens(null);
    }
}

