/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.inscription.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.events.Checking;
import de.renew.engine.events.PlaceEvent;
import de.renew.engine.events.Removing;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

class InputArcExecutable
implements EarlyExecutable {
    private final SimulatablePlaceInstance _placeInstance;
    private final Object _token;
    private final double _delay;
    private final boolean _trace;
    private final boolean _releaseImmediately;
    private double _removeTime;

    InputArcExecutable(SimulatablePlaceInstance pInstance, Object token, double delay, boolean releaseImmediately, boolean trace) {
        this._placeInstance = pInstance;
        this._token = token;
        this._delay = delay;
        this._trace = trace;
        this._releaseImmediately = releaseImmediately;
    }

    public long lockPriority() {
        return this._placeInstance.getLockOrder();
    }

    @Override
    public int phase() {
        return -3;
    }

    public void lock() {
        this._placeInstance._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        this._removeTime = this._placeInstance.removeToken(this._token, this._delay);
    }

    static void traceInArc(StepIdentifier stepIdentifier, boolean checking, Object token, SimulatablePlaceInstance placeInstance) {
        PlaceEvent event = checking ? new Checking(token, placeInstance) : new Removing(token, placeInstance);
        SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)event, (PlaceInstance)placeInstance);
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this._trace) {
            InputArcExecutable.traceInArc(stepIdentifier, this._releaseImmediately, this._token, this._placeInstance);
        }
        if (this._releaseImmediately) {
            this._placeInstance.insertToken(this._token, SearchQueue.getTime());
        }
    }

    @Override
    public void rollback() {
        this._placeInstance.internallyInsertToken(this._token, this._removeTime, false);
    }

    public void unlock() {
        this._placeInstance._lock.unlock();
    }
}

