/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.net.Net;
import de.renew.net.NetLookup;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadowcompiler.ShadowLookupExtension;
import de.renew.shadowcompiler.ShadowLookupExtensionFactory;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ShadowLookup {
    private final Hashtable<String, Net> _netMap = new Hashtable();
    private final HashSet<String> _namesOfNewlyCompiledNets = new HashSet();
    private final Hashtable<ShadowPlace, Place> _placeMap = new Hashtable();
    private final Hashtable<ShadowTransition, Transition> _transitionMap = new Hashtable();
    private final Hashtable<String, ShadowLookupExtension> _extensions = new Hashtable();

    public void setNet(String name, Net net) {
        this._netMap.put(name, net);
    }

    public Net getNet(String name) {
        return this._netMap.get(name);
    }

    public Enumeration<String> allNetNames() {
        return this._netMap.keys();
    }

    public Iterator<String> allNewlyCompiledNetNames() {
        return this._namesOfNewlyCompiledNets.iterator();
    }

    public void set(ShadowPlace element, Place place) {
        this._placeMap.put(element, place);
        this._namesOfNewlyCompiledNets.add(element.getNet().getName());
    }

    public Place get(ShadowPlace element) {
        return this._placeMap.get(element);
    }

    public Enumeration<ShadowPlace> allPlaces() {
        return this._placeMap.keys();
    }

    public void set(ShadowTransition element, Transition transition) {
        this._transitionMap.put(element, transition);
        this._namesOfNewlyCompiledNets.add(element.getNet().getName());
    }

    public Transition get(ShadowTransition element) {
        return this._transitionMap.get(element);
    }

    public Enumeration<ShadowTransition> allTransitions() {
        return this._transitionMap.keys();
    }

    public synchronized ShadowLookupExtension getShadowLookupExtension(ShadowLookupExtensionFactory factory) {
        ShadowLookupExtension extension = this._extensions.get(factory.getCategory());
        if (extension == null) {
            extension = factory.createExtension();
            this._extensions.put(factory.getCategory(), extension);
        }
        return extension;
    }

    public void makeNetsKnown() {
        new NetLookup().makeNetsKnown(this._netMap.values());
    }

    public boolean containsNewlyCompiledNets() {
        return !this._namesOfNewlyCompiledNets.isEmpty();
    }
}

