/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadowcompiler;

import de.renew.net.Net;
import de.renew.net.NetLookup;
import de.renew.shadowcompiler.IShadowNetSystemCompiler;
import de.renew.shadowcompiler.InscriptionValidator;
import de.renew.shadowcompiler.LoopbackNetLoader;
import de.renew.shadowcompiler.ShadowCompiler;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.shadowcompiler.ShadowPreprocessor;
import de.renew.simulatorontology.serialisation.SerialisationListener;
import de.renew.simulatorontology.serialisation.SerialisationListenerRegistry;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShadowNetSystemCompiler
implements IShadowNetSystemCompiler {
    private static final Logger LOGGER = Logger.getLogger(ShadowNetSystemCompiler.class);
    private static final Map<ShadowNetSystem, ShadowCompilerFactory> SHADOW_NET_SYSTEM_COMPILER_FACTORIES = new HashMap<ShadowNetSystem, ShadowCompilerFactory>();
    private static final Map<ShadowNet, ShadowCompilerFactory> SHADOW_NET_COMPILER_FACTORIES = new HashMap<ShadowNet, ShadowCompilerFactory>();

    public static IShadowNetSystemCompiler getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private ShadowNetSystemCompiler() {
        SerialisationListenerRegistry.addListener(ShadowNetSystem.class, (SerialisationListener)new ShadowNetSystemSerialisationListener());
        SerialisationListenerRegistry.addListener(ShadowNet.class, (SerialisationListener)new ShadowNetSerialisationListener());
    }

    @Override
    public void setDefaultCompilerFactory(ShadowCompilerFactory compilerFactory, ShadowNetSystem netSystem) {
        SHADOW_NET_SYSTEM_COMPILER_FACTORIES.put(netSystem, compilerFactory);
        netSystem.recompile();
    }

    @Override
    public void setCompilerFactory(ShadowCompilerFactory compilerFactory, ShadowNet shadowNet) {
        if (compilerFactory == null) {
            SHADOW_NET_COMPILER_FACTORIES.remove(shadowNet);
            return;
        }
        SHADOW_NET_COMPILER_FACTORIES.put(shadowNet, compilerFactory);
    }

    @Override
    public InscriptionValidator createInscriptionValidator(ShadowNet net) {
        return new DefaultInscriptionValidator(net);
    }

    @Override
    public void switchNetSystem(ShadowNet shadowNet, ShadowNetSystem shadowNetSystem) {
        ShadowCompilerFactory defaultCompilerFactory = SHADOW_NET_SYSTEM_COMPILER_FACTORIES.get(shadowNet.getShadowNetSystem());
        ShadowCompilerFactory currentFactory = SHADOW_NET_COMPILER_FACTORIES.get(shadowNet);
        ShadowCompilerFactory newFactory = SHADOW_NET_SYSTEM_COMPILER_FACTORIES.get(shadowNetSystem);
        if (currentFactory == null && (currentFactory = defaultCompilerFactory) != null && !currentFactory.equals(newFactory)) {
            SHADOW_NET_COMPILER_FACTORIES.put(shadowNet, currentFactory);
        }
        shadowNet.switchNetSystem(shadowNetSystem);
        if (currentFactory != null && currentFactory.equals(newFactory)) {
            SHADOW_NET_COMPILER_FACTORIES.remove(shadowNet);
        }
    }

    @Override
    public ShadowCompiler createShadowNetCompiler(ShadowLookup lookup, ShadowNet net) throws SyntaxException {
        ShadowCompiler compiler = this.createShadowNetCompiler(net);
        compiler.setLoopbackNetLoader(new LoopbackNetLoader(net.getShadowNetSystem(), lookup));
        compiler.setShadowLookup(lookup);
        return compiler;
    }

    @Override
    public synchronized ShadowLookup compile(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        return this.compileInternal(shadowNetSystem, new ShadowLookup(), true);
    }

    @Override
    public synchronized ShadowLookup compileMore(ShadowNetSystem shadowNetSystem) throws SyntaxException {
        ShadowLookup shadowLookup = new ShadowLookup();
        Collection<Net> allKnownNets = new NetLookup().getAllKnownNets();
        allKnownNets.forEach(net -> shadowLookup.setNet(net.getName(), (Net)net));
        this.compileInternal(shadowNetSystem, shadowLookup, false);
        return shadowLookup;
    }

    private ShadowLookup compileInternal(ShadowNetSystem shadowNetSystem, ShadowLookup lookup, boolean mayRunPreprocessors) throws SyntaxException {
        this.createNets(lookup, shadowNetSystem);
        this.preprocessNets(lookup, shadowNetSystem, mayRunPreprocessors);
        boolean preprocessorsHaveRun = mayRunPreprocessors;
        while (shadowNetSystem.hasUncompiledNets()) {
            Set shadowNets = shadowNetSystem.getUncompiledNets();
            for (ShadowNet shadowNet : shadowNets) {
                ShadowCompiler compiler = this.createShadowNetCompiler(lookup, shadowNet);
                ShadowPreprocessor[] preprocessors = compiler.getRequiredPreprocessors();
                if (preprocessors != null && preprocessors.length > 0 && !preprocessorsHaveRun) {
                    throw new SyntaxException("Net " + shadowNet.getName() + " was dynamically loaded and requires a preprocessing phase. that is not supported", new String[0]);
                }
                LOGGER.debug((Object)("compiling " + shadowNet.getName() + " using " + String.valueOf(compiler)));
                compiler.compile(shadowNet);
                shadowNetSystem.markAsCompiled(shadowNet);
            }
            preprocessorsHaveRun = false;
        }
        return lookup;
    }

    private void createNets(ShadowLookup lookup, ShadowNetSystem shadowNetSystem) throws SyntaxException {
        Set uncompiledElements = shadowNetSystem.getUncompiledNets();
        for (ShadowNet shadowNet : uncompiledElements) {
            String netName = shadowNet.getName();
            if (new NetLookup().isKnownNet(netName) || lookup.getNet(netName) != null) {
                throw new SyntaxException("Detected two nets with the same name: " + shadowNet.getName() + ".");
            }
            Net net = this.createShadowNetCompiler(lookup, shadowNet).createNet(shadowNet.getName());
            lookup.setNet(netName, net);
        }
    }

    private void preprocessNets(ShadowLookup lookup, ShadowNetSystem shadowNetSystem, boolean mayRunPreprocessors) throws SyntaxException {
        HashSet<ShadowPreprocessor> preprocessors = new HashSet<ShadowPreprocessor>();
        HashSet<String> preprocessorNets = new HashSet<String>();
        Set iterator = shadowNetSystem.getUncompiledNets();
        for (ShadowNet shadowNet : iterator) {
            ShadowCompiler compiler = this.createShadowNetCompiler(lookup, shadowNet);
            ShadowPreprocessor[] requiredPreprocessors = compiler.getRequiredPreprocessors();
            if (requiredPreprocessors == null || requiredPreprocessors.length <= 0) continue;
            preprocessors.addAll(Arrays.asList(requiredPreprocessors));
            preprocessorNets.add(shadowNet.getName());
        }
        if (preprocessors.isEmpty()) {
            return;
        }
        if (!mayRunPreprocessors) {
            StringBuilder builder = new StringBuilder();
            if (preprocessorNets.size() == 1) {
                builder.append("The dynamically loaded net ");
                builder.append((String)preprocessorNets.iterator().next());
                builder.append(" requires");
            } else {
                builder.append("Some dynamically loaded nets (");
                builder.append(String.join((CharSequence)", ", preprocessorNets));
                builder.append(") require");
            }
            builder.append(" a preprocessing phase. This is not allowed.");
            throw new SyntaxException(builder.toString(), new String[0]);
        }
        for (ShadowPreprocessor preprocessor : preprocessors) {
            preprocessor.setShadowLookup(lookup);
            preprocessor.preprocess(shadowNetSystem);
        }
    }

    private ShadowCompiler createShadowNetCompiler(ShadowNet net) throws SyntaxException {
        if (SHADOW_NET_COMPILER_FACTORIES.containsKey(net)) {
            return SHADOW_NET_COMPILER_FACTORIES.get(net).createCompiler();
        }
        ShadowNetSystem shadowNetSystem = net.getShadowNetSystem();
        if (SHADOW_NET_SYSTEM_COMPILER_FACTORIES.containsKey(shadowNetSystem)) {
            return SHADOW_NET_SYSTEM_COMPILER_FACTORIES.get(shadowNetSystem).createCompiler();
        }
        throw new SyntaxException("No compiler or default compiler set for net " + net.getName(), new String[0]);
    }

    private static final class InstanceHolder {
        private static final IShadowNetSystemCompiler INSTANCE = new ShadowNetSystemCompiler();

        private InstanceHolder() {
        }
    }

    private static final class ShadowNetSystemSerialisationListener
    implements SerialisationListener<ShadowNetSystem> {
        private ShadowNetSystemSerialisationListener() {
        }

        public void onWrite(ShadowNetSystem netSystem, ObjectOutputStream outputStream) throws IOException {
            Optional<ShadowCompilerFactory> factory = Optional.ofNullable(SHADOW_NET_SYSTEM_COMPILER_FACTORIES.get(netSystem));
            if (factory.isPresent()) {
                outputStream.writeObject(factory.get());
            }
        }

        public void onRead(ShadowNetSystem netSystem, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            ShadowCompilerFactory factory = (ShadowCompilerFactory)inputStream.readObject();
            SHADOW_NET_SYSTEM_COMPILER_FACTORIES.put(netSystem, factory);
        }
    }

    private static final class ShadowNetSerialisationListener
    implements SerialisationListener<ShadowNet> {
        private ShadowNetSerialisationListener() {
        }

        public void onWrite(ShadowNet net, ObjectOutputStream outputStream) throws IOException {
            Optional<ShadowCompilerFactory> factory = Optional.ofNullable(SHADOW_NET_COMPILER_FACTORIES.get(net));
            if (factory.isPresent()) {
                outputStream.writeObject(factory.get());
            }
        }

        public void onRead(ShadowNet net, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            try {
                ShadowCompilerFactory factory = (ShadowCompilerFactory)inputStream.readObject();
                SHADOW_NET_COMPILER_FACTORIES.put(net, factory);
            }
            catch (OptionalDataException e) {
                LOGGER.debug((Object)("No compiler was read for net " + net.getName()), (Throwable)e);
            }
        }
    }

    private final class DefaultInscriptionValidator
    implements InscriptionValidator {
        private final ShadowNet _net;

        DefaultInscriptionValidator(ShadowNet net) {
            this._net = net;
        }

        @Override
        public String checkArcInscription(String inscription, boolean special) throws SyntaxException {
            return ShadowNetSystemCompiler.this.createShadowNetCompiler(this._net).checkArcInscription(inscription, special, this._net);
        }

        @Override
        public String checkDeclarationNode(String inscription, boolean special) throws SyntaxException {
            return ShadowNetSystemCompiler.this.createShadowNetCompiler(this._net).checkDeclarationNode(inscription, special, this._net);
        }

        @Override
        public String checkPlaceInscription(String inscription, boolean special) throws SyntaxException {
            return ShadowNetSystemCompiler.this.createShadowNetCompiler(this._net).checkPlaceInscription(inscription, special, this._net);
        }

        @Override
        public String checkTransitionInscription(String inscription, boolean special) throws SyntaxException {
            return ShadowNetSystemCompiler.this.createShadowNetCompiler(this._net).checkTransitionInscription(inscription, special, this._net);
        }
    }
}

